package org.gualdi.utils

import javax.servlet.http.HttpServletResponse

class FileUtils {

	// utils
	static public generateUniqueFilename( path ) {
		return File.createTempFile("temp-", ".tmp", new File(path)).name
	}

	static public File createTempDir(path) {
		File p = new File(path)
		if (!p.exists()) {
			p.mkdirs()
		}

        File tempFile = File.createTempFile('temp','', p)
        tempFile.delete()
        tempFile.mkdirs()
        return tempFile
	}
	
	static public sendFile(String filename, String downloadFilename, HttpServletResponse response, contentType = 'application/octet-stream', deleteSource = false) {
        File outFile = new File(filename)

        response.setHeader("Content-Type", "${contentType};")
        response.setHeader("Content-Disposition", "attachment; filename=\"${downloadFilename}\"")
        response.setHeader("Content-Length", "${outFile.size()}")

        def os = response.outputStream

        byte[] buff = null
        BufferedInputStream bis = new BufferedInputStream( new FileInputStream( outFile ) )
        try
        {
            buff = new byte[2048]
            int bytesRead = 0
            while ( (bytesRead = bis.read( buff, 0, buff.size() )) != -1 ) {
                os.write( buff, 0, bytesRead )
            }
        }
        finally {
            bis.close()
            os.flush()
            os.close()
        }

        // Se richiesto elimina il file inviato
        if (deleteSource) {
            outFile.delete()
        }
    }
    
}