package org.gualdi.grails.plugins.cms.co

import org.springframework.context.ApplicationContext
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes
import org.gualdi.grails.plugins.cms.domain.Category
import grails.validation.Validateable

@Validateable
class CmsCategoriesCommand {

  // Inject service, needed because we are manually creating the command object
  ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
  def cmsBaseService = ctx.getBean('cmsBaseService')

  Long id
  String name
  Category parent
  String pageTag
  String description
  String image
  Boolean hidden = false
  String role
  String protectionTag

  String sitetag

  static constraints = {
    id nullable: true
    parent nullable: true, bindable: true

    importFrom Category

    protectionTag blank: true, nullable: true, maxSize: 50, matches: /[a-z0-9_-]*/, validator: { value, obj ->
      if (value) {
        if (!obj.cmsBaseService.isProtectionTagUnique(value, obj.sitetag, obj.id)) {
          return ['unique']
        }
      }
    }

    sitetag nullable: true, blank: true
  }

}
