package org.gualdi.grails.plugins.cms.co

import grails.validation.Validateable
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes
import org.gualdi.grails.plugins.cms.domain.Banner
import org.springframework.context.ApplicationContext

@Validateable
class CmsBannersCommand {

    // Inject service, needed because we are manually creating the command object
    ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
    def cmsBaseService = ctx.getBean('cmsBaseService')

    Long id
    String tag
    Boolean active = false
    String position
    String positionSelector
    String title
    String image
    String url
    String pageTag
    String body
    Integer ordine = 0

    String sitetag

    static constraints = {
        id nullable: true

        tag blank: true, nullable: true, maxSize: 50, matches: /[a-z0-9_-]*/, validator: { value, obj ->
            if (value) {
                if (!obj.cmsBaseService.isBannerTagUnique(value, obj.sitetag, obj.id)) {
                    return ['unique']
                }
            }
        }

        importFrom Banner, exclude: ['tag']

        sitetag nullable: true, blank: true
    }
}
