<%@ page contentType="text/html;charset=UTF-8" %>

<html>
    <head>
        <meta name="layout" content="ixcms2"/>
    </head>

    <body>
        <div class="page-header">
            <h1><g:message code="cms.sites.title"/></h1>
        </div>

        <div class="row-fluid">

            <g:render template="/cms/sites/actions"/>

            <div class="span9">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th style="width: 15%"><g:message code="cmsSitesCommand.tag.label"/></th>
                        <th style="width: 65%"><g:message code="cmsSitesCommand.name.label"/></th>
                        <th style="width: 20%">&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <g:each in="${list}" var="s">
                        <tr>
                            <td>${s.tag}</td>
                            <td>${s.name}</td>
                            <td>
                                <div class="btn-group">
                                    <g:link action="selectSite" id="${s.tag}" class="btn btn-primary"><g:message code="cms.button.select"/></g:link>
                                    <button class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <g:link action="editSite" id="${s.id}"><i class="icon-edit"></i> <g:message code="cms.button.edit"/></g:link>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0)" class="delete-button" data-row-id="${s.id}"><i class="icon-trash"></i> <g:message code="cms.button.delete"/></a>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>

            <div class="span1">
                &nbsp;
            </div>
        </div>

        <g:render template="/cms/common/dialogs/deleteDialog" model="[controller: 'cmsAdmin', action:'deleteSite', dialogTitle: message(code: 'cms.sites.dialog.delete.title'), dialogBody: message(code: 'cms.sites.dialog.delete.body'), dialogId: 'delete-dialog', buttonClass:'delete-button']"/>
    </body>
</html>