<%@ page contentType="text/html;charset=UTF-8" %>

<html>
<head>
    <meta name="layout" content="ixcms2"/>

    <r:require modules="jquery-jqtree, jquery-jqote2"/>

    <g:render template="/cms/pages/templates"/>

    <r:script>
            function getTreeJSON(id) {
                return $(id).tree('toJson');
            }

            function getNodeById(id, nodeId) {
                return $(id).tree('getNodeById', nodeId);
            }

            function getSelectedNode(id) {
                return $(id).tree('getSelectedNode');
            }

            function openInfoPane(node) {
                $.ajax({
                    url:'${createLink(controller: 'cmsAdmin', action: 'siteObject', params: [sitetag: params.sitetag])}',
                    dataType:'json',
                    data: {
                        id: node.objId,
                        type: node.type
                    }
                }).done(function(data) {
                    var txt = $('#info-' + data.type + '-template').jqote(data, '*');
                    $('#info-pane').html(txt);
                });
            }

            function nodeSelected(event) {
                openInfoPane(event.node);
            }

            function onInit() {
                // If a node is selected open the info panel
                var selectedNode = getSelectedNode("#tree");
                if (selectedNode) {
                    openInfoPane(selectedNode);
                }
            }

            function onCreateElement(node, li) {
                var type = node.type;
                if (type == 'category' && node.children.length == 0) {
                    li.addClass('jqtree-empty-folder');
                }
                li.find("div:first").addClass(type);
                li.find('.jqtree-title').html('<span class="ixcms-tree-' + type + '">' + node.name + '</span>');
            }

            function onCanMove(moved_node, target_node, position) {
                var result = false;
                if (moved_node.type == 'category') {
                    result = true;
                    if (target_node.type == 'page' && position == 'inside') {
                        result = false;
                    }
                }
                else if (moved_node.type == 'page') {
                    result = true;
                    if (target_node.parent.parent == null && position != "inside") {
                        result = false;
                    }
                    else if (target_node.type == 'page' && position == 'inside'){
                        result = false;
                    }
                }

                return result;
            }

            function getObjectsOrder(event) {
                var node = getNodeById("#tree", event.move_info.target_node.id);
                var tmp = null;
                if (event.move_info.target_node.type == 'category' && event.move_info.position == 'inside') {
                    tmp = node;
                }
                else {
                    tmp = node.parent;
                }

                var result = [];
                $.each(tmp.children, function(index, item){
                    result.push({id: item.objId, order: index + 1, type: item.type});
                });

                return result;
            }

            function onMove(event) {
                 // Finish to move the node to get the updated tree
                event.move_info.do_move();

                var objectsOrder = getObjectsOrder(event);

                var tree = getTreeJSON("#tree");
                var data = {
                    source: {
                        id:event.move_info.moved_node.id,
                        objId:event.move_info.moved_node.objId,
                        type:event.move_info.moved_node.type
                    },
                    target: {
                        id:event.move_info.target_node.id,
                        objId:event.move_info.target_node.objId,
                        type:event.move_info.target_node.type,
                        position:event.move_info.position
                    },
                    objectsOrder: objectsOrder,
                    tree: tree
                };

                $.ajax({
                    url:'${createLink(controller: 'cmsAdmin', action: 'moveObject', params: [sitetag: params.sitetag])}',
                    type:'post',
                    dataType:'json',
                    data: {info: JSON.stringify(data)},
                    beforeSend: function(x) {
                        if (x && x.overrideMimeType) {
                            x.overrideMimeType("application/j-son;charset=UTF-8");
                        }
                    }
                }).done(function(data) {
                    // Do nothing
                });
            }

            function collapseOrExpand(id, expand) {
                var f = expand ? 'openNode' : 'closeNode';
                var $tree = $(id);
                var tree = $tree.tree('getTree');
                tree.iterate(function(node) {
                    if (node.hasChildren()) {
                        $tree.tree(f, node, false);
                    }
                    return true;
                });
            }

            function onExpand() {
                collapseOrExpand('#tree', true);
            }

            function onCollapse() {
                collapseOrExpand('#tree', false);
            }

            $(function () {
                // Tree view
                var tree = $('#tree').tree({
                    autoOpen:0, // Open only the first level
                    dragAndDrop:true,
                    selectable:true,
                    saveState:true,
                    onCreateLi:onCreateElement,
                    onCanMoveTo:onCanMove
                });
                tree.bind('tree.click', nodeSelected);
                tree.bind('tree.move', onMove);
                tree.bind('tree.init', onInit);

                // Expand and collapse
                $('#collapse-tree').click(onCollapse);
                $('#expand-tree').click(onExpand);
            })
    </r:script>
</head>

<body>
    <div class="page-header">
        <h1><g:message code="cms.manage.title"/></h1>
    </div>

    <g:render template="/cms/pages/actions"/>

    <p></p>

    <div class="row-fluid">

        <div class="span6">
            <div class="well">
                <h2><g:message code="cms.manage.title.siteStructure"/></h2>

                <div class="pull-right">
                    <i id="expand-tree" class="icon-resize-full" style="cursor: pointer;"></i> <i id="collapse-tree" class="icon-resize-small" style="cursor: pointer;"></i>
                </div>

                <p></p>

                <div id="tree" data-url="${createLink(controller: 'cmsAdmin', action: 'siteStructure', params: [sitetag: params.sitetag])}"></div>
            </div>
        </div>

        <div class="span6">
            <div id="info-pane" class="span5" data-spy="affix"></div>
        </div>

    </div>

    <g:render template="/cms/common/dialogs/deleteDialog" model="[controller: 'cmsAdmin', action: 'deleteCategory', params: [sitetag: params.sitetag], dialogTitle: message(code: 'cms.categories.dialog.delete.title'), dialogBody: message(code: 'cms.categories.dialog.delete.body'), dialogId: 'delete-category-dialog', buttonClass: 'delete-category-button']"/>

    <g:render template="/cms/common/dialogs/deleteDialog" model="[controller: 'cmsAdmin', action: 'deletePage', params: [sitetag: params.sitetag], dialogTitle: message(code: 'cms.pages.dialog.delete.title'), dialogBody: message(code: 'cms.pages.dialog.delete.body'), dialogId: 'delete-page-dialog', buttonClass: 'delete-page-button']"/>
</body>
</html>