<%@ page contentType="text/html;charset=UTF-8" %>

<html>
    <head>
        <meta name="layout" content="ixcms2"/>
    </head>

    <body>
        <div class="page-header">
            <h1><g:message code="cms.banners.title"/></h1>
        </div>

        <div class="row-fluid">

            <g:render template="/cms/banners/actions"/>

            <div class="span9">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th style="width: 15%"><g:message code="cmsBannersCommand.position.label"/></th>
                        <th style="width: 10%"><g:message code="cmsBannersCommand.ordine.label"/></th>
                        <th style="width: 10%"><g:message code="cmsBannersCommand.tag.label"/></th>
                        <th style="width: 40%"><g:message code="cmsBannersCommand.title.label"/></th>
                        <th style="width: 10%"><g:message code="cmsBannersCommand.active.label"/></th>
                        <th style="width: 15%">&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <g:each in="${list}" var="i">
                        <tr>
                            <td><g:message code="cmsBannersCommand.position.${i.position}"/></td>
                            <td>${i.ordine}</td>
                            <td>${i.tag}</td>
                            <td>${i.title}</td>
                            <td>
                                <g:if test="${i.active}">
                                    <span class="label label-success"><g:message code="cms.manage.label.yes"/></span>
                                </g:if>
                                <g:else>
                                    <span class="label label-important"><g:message code="cms.manage.label.no"/></span>
                                </g:else>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <g:link action="editBanner" id="${i.id}" params="[sitetag: params.sitetag]" class="btn btn-primary"><g:message code="cms.button.edit"/></g:link>
                                    <button class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a href="javascript:void(0)" class="delete-button" data-row-id="${i.id}"><i class="icon-trash"></i> <g:message code="cms.button.delete"/>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    </g:each>
                    </tbody>
                </table>

                <cmsadmin:paginate total="${list.totalCount}" params="[sitetag: params.sitetag]"/>
            </div>

            <div class="span1">
                &nbsp;
            </div>
        </div>

        <g:render template="/cms/common/dialogs/deleteDialog" model="[controller: 'cmsAdmin', action: 'deleteBanner', params: [sitetag: params.sitetag], dialogTitle: message(code: 'cms.banners.dialog.delete.title'), dialogBody: message(code: 'cms.banners.dialog.delete.body'), dialogId: 'delete-dialog', buttonClass:'delete-button']"/>
    </body>
</html>