package org.gualdi.plugins.cms

import grails.plugin.cache.Cacheable
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo
import org.gualdi.grails.plugins.ckeditor.utils.MimeUtils
import org.gualdi.grails.plugins.ckeditor.utils.PathUtils
import org.gualdi.grails.plugins.cms.commands.CommandProcessor
import org.gualdi.grails.plugins.cms.domain.Category
import org.gualdi.grails.plugins.cms.domain.Page
import org.gualdi.grails.plugins.cms.domain.Site

class CmsContentService {

  static transactional = false

  def grailsUrlMappingsHolder
  def grailsApplication
  def cmsBaseService
  def cmsContentService
  def cmsSecurityService

  // =====================================================================
  // Uploaded files
  // =====================================================================
  def getUploadUrl() {
    // TODO: refactor
    def url = grailsApplication.config.ckeditor.upload.basedir
    return url
  }

  def getUploadTypes() {
    // TODO: refactor
    def types = ['Image', 'File', 'Flash']
    return types
  }

  def getUploadPath(uri) {
    // TODO: refactor
    def fname = grailsApplication.mainContext.servletContext.getRealPath(uri)
    return new File(fname)
  }

  def canUserViewFile(sitetag, categoryTags) {
    // TODO: optimize and cache
    def canView = true
    Site.withTransaction {
      def activeUserRoles = cmsSecurityService.currentUserRoles

      if (!("ROLE_ADMIN" in activeUserRoles)) {
        // se uno dei category tags risolve una categoria
        // i permessi della categoria sono i permessi del file
        // L'utente può vedere il file se ha il permesso trovato per la categoria
        def site = sitetag ? Site.findByTag(sitetag) : null
        def categories = site ? site.categoriesFlat : null

        def found = false
        def s = categoryTags.size()
        def i = 0
        while (i < s && !found) {
          log.debug "Look for protectionTag -> ${categoryTags[i]}"
          def category
          if (site) {
            category = categories.find { it.protectionTag == categoryTags[i] }
          } else {
            category = Category.findByProtectionTag(categoryTags[i])
          }

          if (category) {
            found = true
            log.debug "Check category role ${category.role}"
            canView = category.role in activeUserRoles
          }
          i++
        }
      } else {
        log.debug "NO CHECK FOR ROLE_ADMIN "
      }
    }

    return canView
  }

  // =====================================================================
  // Rendering contents support
  // =====================================================================
  def getCategory(categoryId, sitetag) {
    def site = Site.findByTag(sitetag)

    def category
    def activeUserRoles = cmsSecurityService.currentUserRoles
    def userCanViewCategory
    if (categoryId) {
      category = Category.get(Long.parseLong(categoryId))
      userCanViewCategory = category?.isVisibleForRoles(activeUserRoles)
    } else {
      category = site
      userCanViewCategory = true
    }

    if (category && userCanViewCategory) {
      def children = []

      def allItems = category?.sortedCategories
      if (categoryId) {
        allItems += category?.sortedPages
      }

      allItems.sort { it.ordine }.each { v ->
        if (v instanceof org.gualdi.grails.plugins.cms.domain.Category) {
          if (v.isVisibleForRoles(activeUserRoles) && !v.hidden) {
            if (v.pageTag) {
              children << [id: v.pageTag, name: v.name, type: 'page', image: v.image, description: v.description, sitetag: sitetag]
            } else {
              children << [id: v.id, name: v.name, type: 'category', image: v.image, description: v.description,  sitetag: sitetag]
            }
          }
        } else {
          if (!v.hidden) {
            children << [id: v.id, name: v.title, type: 'page',  image: v.image, description: v.description, sitetag: sitetag]
          }
        }
      }

      return [site: site, category: category, children: children]
    } else {
      // La categoria non esiste oppure è protetta e non è visibile per i ruoli di questo utente
      def errorMsg = !category ? 'categoryNotFound' : 'categoryNotVisible'
      def errorCode = !category ? 404 : 403
      return [error: errorMsg, errorCode: errorCode, site: site]
    }
  }

  def getPage(pageid, sitetag) {
    def defaultPage = grailsApplication.config.cms.site.defaultPage

    def site = Site.findByTag(sitetag)

    Page page
    if (pageid) {
      if (pageid?.isNumber()) {
        page = site?.getPageById(Long.parseLong(pageid))
      } else {
        page = site?.getPageByTag(pageid)
      }
    } else {
      page = site?.getPageByTag(defaultPage)
    }

    def activeUserRoles = cmsSecurityService.currentUserRoles
    def userCanViewPage = page?.isVisibleForRoles(activeUserRoles)
    if (page && userCanViewPage) {
      // Verifica se e' una pagina di comando
      def command = page.commands
      if (command) {
        def processor = new CommandProcessor()
        def res = processor.process(command)
        if (res) {
          res.params['site'] = sitetag
          // res contiene tutti i dati necessari alla chiamata del controller
          // Redirect al controller che implementa il comando
          // Passa sempre come id l'id della pagina che ha innescato il comando
          // Dopo il redirect e' compito del controller che implementa il comando la gestione delle azioni seguenti
          return [command: [controller: res.controller, action: res.action, params: res.params, id: page.id]]
        } else {
          return [error: 'invalidPageCommand', site: site]
        }
      } else {
        return [site: site, page: page]
      }
    } else {
      // La pagina non esiste oppure è protetta e non è visibile per i ruoli di questo utente
      def errorMsg = !page ? 'pageNotFound' : 'pageNotVisible'
      def errorCode = !page ? 404 : 403
      return [error: errorMsg, errorCode: errorCode, site: site]
    }
  }

  // =====================================================================
  // Uploaded files support
  // =====================================================================

  @Cacheable(value = 'ixcms-uploads', key = "#filepath+#userRoles")
  Map getDownloadableObject(String filepath, String referer, ArrayList<String> userRoles) {
    def result = createFileObject(filepath)

    result.visible = false

    def mInfo = decomposeReferer(referer)
    if (mInfo) {
      if (mInfo.controllerName in ['cmsAdmin', 'openFileManagerConnector']) {
        result.visible = true
      } else {
        def page
        try {
          Long id = Long.parseLong(mInfo.id)
          page = cmsBaseService.getPage(Long.parseLong(id))
        }
        catch (NumberFormatException nfe) {
          // Get by tag
          page = cmsBaseService.getPage(mInfo.parameters['site'], mInfo.id)
        }

        result.visible = page.isVisibleForRoles(userRoles)
      }
    }

    if (log.isDebugEnabled()) {
      log.debug "Cache resource protection info for ${filepath} for roles ${userRoles}"
    }

    return result
  }

  Map createFileObject(String filepath) {
    def fileObject = [:]

    fileObject.uploadPath = grailsApplication.config.ckeditor.upload?.basedir
    fileObject.ext = PathUtils.splitFilename(filepath).ext
    fileObject.filepath = filepath
    fileObject.contentType = MimeUtils.getMimeTypeByExt(fileObject.ext)

    return fileObject
  }

  private UrlMappingInfo decomposeReferer(String referer) {
    UrlMappingInfo mappingInfo = null
    if (referer) {
      def contextPath = grailsApplication.mainContext.servletContext.getContextPath()
      if (contextPath == "") {
        contextPath = "/"
      }

      def pagePath = referer.substring(referer.indexOf(contextPath) + contextPath.size())

      mappingInfo = grailsUrlMappingsHolder.match(pagePath)
    }

    return mappingInfo
  }
}
