package org.gualdi.grails.plugins.cms.domain

class Site implements Serializable {
	static hasMany = [categories: Category]

	String tag
	String name
    String title
    String meta
	String googleTag

    def getPageById(Long id) {
        def pages = getPages()
        def page = pages.find { p -> p.id == id }
        return page
    }

    def getPageByTag(String tag) {
        def pages = getPages()
        def page = pages.find { p -> p.tag == tag }
        return page
    }

    def getSortedCategories() {
        Site.withNewSession {
            return this.categories?.sort { a, b -> a.ordine == b.ordine ? a.name <=> b.name : a.ordine <=> b.ordine }
        }
    }

    def getPages() {
        // Ottiene tutte le pagine
        def pages = []
        Site.withNewSession {
            getPagesImpl(this, pages)
        }
        return pages
    }

    private getPagesImpl(root, result) {
        if (root instanceof Category) {
            root?.pages?.each { p ->
                result << p
            }
        }
        root?.categories?.each { c ->
            getPagesImpl(c, result)
        }
    }

    def getCategoriesFlat() {
        // Ottiene tutte le categorie
        def categories = []
        Site.withNewSession {
            getCategoriesFlatImpl(this, categories)
        }
        return categories
    }

    private getCategoriesFlatImpl(root, result) {
        if (root instanceof Category) {
            result << root
        }
        root?.categories?.each { c ->
            getCategoriesFlatImpl(c, result)
        }
    }
    
    static constraints = {
		tag(nullable: false, blank: false, unique: true, maxSize: 50, matches: /[a-z0-9_-]*/)
		name(nullable: false, blank: false, maxSize: 255)
        title(nullable: false, blank: false, maxSize: 255)
        meta(nullable: true, blank: true)
		googleTag(nullable: true, blank: true)
    }

    static mapping = {
        columns {
            meta type: 'text'
        }
    }
}

