package org.gualdi.grails.plugins.cms.domain

class Banner implements Serializable {
    Site site

    String tag
    Boolean active = false
    String position
    String positionSelector
    String title
    String image
    String url
    String pageTag
    String body
    Integer ordine = 0

    static constraints = {
        tag(blank: true, nullable:true, maxSize: 50, matches: /[0-9a-z_-]*/, validator: { value, obj ->
            if (value) {
                // Verifica il rispetto dell'unicita' del tag nel sito
                def s = obj.site
                def banners = Banner.findAllBySite(s)
                if (banners.any { b -> (b.tag == value) && (obj.id ? (b.id != obj.id) : true) }) {
                    return ['banner.error.tagMustBeUnique']
                }
            }
        })
        active(nullable: false)
        position(nullable: false, blank: false, inList: ['TOP', 'BOTTOM', 'LEFT', 'RIGHT', 'CENTER', 'SLIDER'])
        positionSelector(nullable: true, blank: true, maxSize: 50)
        title(nullable: false, blank: false)
        image(nullable: true, blank: true, maxSize: 255)
        url(nullable: true, blank: true, maxSize: 255)
        pageTag(nullable: true, blank: true, maxSize: 50)
        body(nullable: true, blank: true)
        ordine(nullable: true, blank: false)
    }

    static mapping = {
        body type: 'text'
    }
}
