package org.gualdi.grails.plugins.cms

abstract class CmsBaseContentController {

    static CMS_REQUEST_ATTRIBUTES_KEY = "ixcms.request.attributes.params"

    protected saveParams(Map params) {
        if (params) {
            request.setAttribute(CMS_REQUEST_ATTRIBUTES_KEY, params)
        }
    }

    protected retrieveParams() {
        def prms = request.getAttribute(CMS_REQUEST_ATTRIBUTES_KEY)
        if (prms) {
            webRequest?.parameterMap?.putAll(prms)
        }
    }

    protected sendError(int errorCode, Map params) {
        saveParams(params)
        response.sendError(errorCode)
    }
}
