class Ixcms2UrlMappings {

    static mappings = {
        // Entry point
        "/" (controller: "cmsContent", action: "index")

         // Site user side mappings
        "/site/$site" (controller: "cmsContent", action: "index")
        "/site/$site/page/$id" (controller: "cmsContent", action: "show")
        "/site/$site/category/$id" (controller: "cmsContent", action: "showCategory")

        // Main mapping to cms dynamic controller
        "/cms"(controller: "cmsAdmin", action: "index")

        "/cms/site/list"(controller: "cmsAdmin", action: "listSites")
        "/cms/site/select/$id"(controller: "cmsAdmin", action: "selectSite")
        "/cms/site/add"(controller: "cmsAdmin", action: "addSite")
        "/cms/site/edit/$id"(controller: "cmsAdmin", action: "editSite")
        "/cms/site/delete"(controller: "cmsAdmin", action: "deleteSite")

        // Generic action across modules
        "/cms/site/$sitetag/exec/$action/$id?"(controller: "cmsAdmin")

        // Errors
        "403"(controller: "cmsError", action: "forbidden")
        "404"(controller: "cmsError", action: "notFound")
        "500"(controller: "cmsError", action: "internalError")
        "503"(controller: "cmsError", action: "protectedResource")
    }
}
