// Date picker
function initDatePicker(id, format) {
    $(id).datepicker({
        format:format
    });
}

// Tags
function initTagsEditor(id, url) {
    $(id).select2({
        multiple:true,
        initSelection:function (element, callback) {
            var initialValue = $(element).val();
            var result = [];
            if (initialValue) {
                var tmp = initialValue.split(',');
                $.each(tmp, function (idx, tag) {
                    result.push({
                        id:tag.trim(),
                        text:tag.trim()
                    });
                });
            }
            callback(result);
        },
        query:function (query) {
            $.ajax({
                url:url,
                dataType:'json',
                data:{
                    q:query.term
                }
            }).done(function (response) {
                var data = {
                    results:[]
                };

                //Push the query term first, so it ll become selectable (kinda like adding new tag)
                if (query.term) {
                    data.results.push({
                        id:query.term,
                        text:query.term
                    });
                }

                $.each(response, function (idx, tag) {
                    data.results.push({
                        id:tag,
                        text:tag
                    });
                });

                query.callback(data);
            });
        }
    });
}