package org.gualdi.grails.plugins.cms.security

import org.apache.commons.logging.LogFactory
import org.springframework.context.ApplicationContext
import org.springframework.context.ApplicationContextAware

class CmsSecurityImpl implements CmsSecurityInterface, ApplicationContextAware {
	final log = LogFactory.getLog(CmsSecurityImpl)

    def cmsSecurityBridge
    ApplicationContext applicationContext

    // Setup
    void setApplicationContext(ApplicationContext context) {
        this.@applicationContext = context
        if (context.containsBean('cmsSecurityBridge')) {
            cmsSecurityBridge = context.getBean('cmsSecurityBridge')
        }
    }

    // Access the bridge
    CmsSecurityInterface getCmsSecurityBridge(boolean throwIfNone = false) {
        if (!cmsSecurityBridge) {
            def msg = "A security bridge must be provided by the application!!!"
            if (throwIfNone) {
                throw new IllegalArgumentException(msg)
            } else if (log.warnEnabled) {
                log.warn msg
            }
        }
        cmsSecurityBridge
    }

    // Methods implemented by the bridge as specified in CmsSecurity interface
	List<String> getAllRoles() {
		getCmsSecurityBridge()?.getAllRoles()
	}

    List<String> getUserRoles(String username) {
		getCmsSecurityBridge()?.getUserRoles(username)
    }

    List<String> getCurrentUserRoles() {
    	getCmsSecurityBridge()?.getCurrentUserRoles()
    }
}
