<r:require modules="form-utils"/>

<r:script>
    function openWindow(){
        window.open('${cmsadmin.fileBrowserLink(type:'image', fileBrowser:'ofm', showThumbs:'true')}', null, 'location=no,menubar=no,toolbar=no,dependent=yes,minimizable=no,modal=yes,alwaysRaised=yes,resizable=yes,scrollbars=yes,width=1066,height=525,top=112,left=133');
    }

    function ckeditorFileBrowserItemSelected(path) {
        $("#image").val(path);
    }

    $(function () {
        initDatePicker('#date', 'dd/mm/yyyy');
        initTagsEditor('#tags', '${createLink(controller: 'cmsAdmin', action: 'tagsForNews', params: [sitetag: params.sitetag])}');
    });
</r:script>

<g:render template="/cms/common/richEditorConfig"/>

<f:with bean="${cmd}">
    <f:field property="date">
        <div class="input-append">
            <g:textField name="${property}" value="${formatDate(date: value, format: 'dd/MM/yyyy')}" size="16" class="span8"/><span class="add-on"><i class="icon-th"></i></span>
        </div>
    </f:field>
    <f:field property="size">
        <g:select name="${property}" value="${value}" from="${org.gualdi.grails.plugins.cms.co.CmsNewsCommand.constraints.size.inList}" valueMessagePrefix="cmsNewsCommand.size" noSelection="['':'']" class="input-large"></g:select>
    </f:field>
    <f:field property="title" input-class="input-xxlarge"/>
    <f:field property="description">
        <g:textArea name="${property}" value="${value}" rows="3" cols="10" class="input-xxlarge"/>
    </f:field>

    <f:field property="highlight" input-class="input-small"/>

    <f:field id="image" property="image">
        <div class="input-append">
            <g:textField name="${property}" value="${value}" class="input-xxlarge"/><a href="javascript:openWindow()"><span class="add-on"><i class="icon-camera"></i></span></a>
        </div>
    </f:field>

    <f:field property="tags">
        <input type="hidden" id="${property}" name="${property}" class="input-xxlarge" value="${value}"/>
    </f:field>
    <f:field property="body">
        <cmsadmin:richEditor name="${property}" toolbar="Ixcms2" width="98%" height="300">${value}</cmsadmin:richEditor>
    </f:field>
</f:with>
