package org.gualdi.grails.plugins.cms

import org.springframework.web.servlet.support.RequestContextUtils

/*
    TagLib for internal use by the admin system
*/
class Ixcms2AdminTagLib {

    static namespace = "cmsadmin"

    def messageSource
    def cmsBaseService

    def version = {
        def v = applicationContext.getBean('pluginManager').allPlugins.find {plugin -> plugin.name == 'ixcms2'}?.version
        out << v
    }

    def link = { attrs, body ->
        def sitetag = params?.sitetag
        def ignoreSitetag = attrs?.ignoreSitetag
        if (sitetag && !ignoreSitetag) {
            if (!attrs.params) {
                attrs.params = [:]
            }
            attrs.params['sitetag'] = sitetag
        }
        out << g.link(attrs) { body() }
    }

    def renderAdminMenu = {
        def menuItems = cmsBaseService.composeAdminMenuFromMixins()

        def locale = RequestContextUtils.getLocale(request)

        def buf = "" << ""
        menuItems.sort { a, b -> a.value.order <=> b.value.order }.each { key, value ->
            def ignoreSitetag = !value?.useSitetag
            def canBeRedered = value.useSitetag ? params?.sitetag != null : true
            def enabledSites = grailsApplication.config?.cmsadmin?.menu[key]
            def isEnabledForThisSite = params?.sitetag in enabledSites
            if (canBeRedered && isEnabledForThisSite) {
                if (value.items?.size() > 0) {
                    buf << """<li class="dropdown">\n"""
                    buf << """<a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">${messageSource.getMessage(value.key, null, "${value.key}", locale)}<b class="caret"></b></a>\n"""

                    buf << """<ul class="dropdown-menu">\n"""
                    value.items.each { item ->
                        buf << """<li>${cmsadmin.link(controller: "cmsAdmin", action: item.action, ignoreSitetag: ignoreSitetag) {messageSource.getMessage(item.key, null, "${item.key}", locale)}}</li>"""
                    }
                    buf << "</ul>\n"
                    buf << "</li>\n"
                }
                else {
                    buf << """<li>${cmsadmin.link(controller: "cmsAdmin", action: value.action, ignoreSitetag: ignoreSitetag) {messageSource.getMessage(value.key, null, "${value.key}", locale)}}</li>"""
                }
            }
        }

        out << buf
    }

    /**
     * Override the standard ckeditor:editor tag to check the application config and use or not the user space
     * to separate uploaded contents between sites.
     * To configure use: cms.uploads.singleSpace = true | false (default false)
     */
    def richEditor = { attrs, body ->
        def config = grailsApplication.config
        if (!config?.cms?.uploads?.singleSpace) {
            attrs['userSpace'] = params.sitetag
        }
        out << ckeditor.editor(attrs) { body() }
    }

    /**
     * Override the standard ckeditor:fileBrowserLink tag to check the application config and use or not the user space
     * to separate uploaded contents between sites.
     * To configure use: cms.uploads.singleSpace = true | false (default false)
     */
    def fileBrowserLink = { attrs ->
        def config = grailsApplication.config
        if (!config?.cms?.uploads?.singleSpace) {
            attrs['userSpace'] = params.sitetag
        }
        out << ckeditor.fileBrowserLink(attrs)
    }

    /**
     * Creates next/previous links to support pagination for the current controller.<br/>
     *
     * &lt;g:paginate total="${Account.count()}" /&gt;<br/>
     *
     * @emptyTag
     *
     * @attr total REQUIRED The total number of results to paginate
     * @attr action the name of the action to use in the link, if not specified the default action will be linked
     * @attr controller the name of the controller to use in the link, if not specified the current controller will be linked
     * @attr id The id to use in the link
     * @attr params A map containing request parameters
     * @attr prev The text to display for the previous link (defaults to "Previous" as defined by default.paginate.prev property in I18n messages.properties)
     * @attr next The text to display for the next link (defaults to "Next" as defined by default.paginate.next property in I18n messages.properties)
     * @attr max The number of records displayed per page (defaults to 10). Used ONLY if params.max is empty
     * @attr maxsteps The number of steps displayed for pagination (defaults to 10). Used ONLY if params.maxsteps is empty
     * @attr offset Used only if params.offset is empty
     * @attr fragment The link fragment (often called anchor tag) to use
     */
    def paginate = { attrs ->
        def writer = out
        if (attrs.total == null) {
            throwTagError("Tag [paginate] is missing required attribute [total]")
        }
        def messageSource = grailsAttributes.messageSource
        def locale = RequestContextUtils.getLocale(request)

        def total = attrs.int('total') ?: 0
        def action = (attrs.action ? attrs.action : (params.action ? params.action : "list"))
        def offset = params.int('offset') ?: 0
        def max = params.int('max')
        def maxsteps = (attrs.int('maxsteps') ?: 10)

        if (!offset) offset = (attrs.int('offset') ?: 0)
        if (!max) max = (attrs.int('max') ?: 10)

        def linkParams = [:]
        if (attrs.params) linkParams.putAll(attrs.params)
        linkParams.offset = offset - max
        linkParams.max = max
        if (params.sort) linkParams.sort = params.sort
        if (params.order) linkParams.order = params.order

        def linkTagAttrs = [action: action]
        if (attrs.controller) {
            linkTagAttrs.controller = attrs.controller
        }
        if (attrs.id != null) {
            linkTagAttrs.id = attrs.id
        }
        if (attrs.fragment != null) {
            linkTagAttrs.fragment = attrs.fragment
        }
        linkTagAttrs.params = linkParams

        // determine paging variables
        def steps = maxsteps > 0
        int currentstep = (offset / max) + 1
        int firststep = 1
        int laststep = Math.round(Math.ceil(total / max))

        writer << '<div class="pagination"><ul>'
        // display previous link when not on firststep
        if (currentstep > firststep) {
            linkParams.offset = offset - max
            writer << '<li class="prev">'
            writer << link(linkTagAttrs.clone()) {
                (attrs.prev ?: messageSource.getMessage('paginate.prev', null, messageSource.getMessage('default.paginate.prev', null, 'Previous', locale), locale))
            }
            writer << '</li>'
        }
        else {
            if (laststep > 1) {
                writer << '<li class="prev disabled">'
                writer << """<a href="javascript:void(0)">${(attrs.prev ? attrs.prev : messageSource.getMessage('paginate.next', null, messageSource.getMessage('default.paginate.prev', null, 'Previous', locale), locale))}</a>"""
                writer << '</li>'
            }
        }

        // display steps when steps are enabled and laststep is not firststep
        if (steps && laststep > firststep) {
            linkTagAttrs.class = 'step'

            // determine begin and endstep paging variables
            int beginstep = currentstep - Math.round(maxsteps / 2) + (maxsteps % 2)
            int endstep = currentstep + Math.round(maxsteps / 2) - 1

            if (beginstep < firststep) {
                beginstep = firststep
                endstep = maxsteps
            }
            if (endstep > laststep) {
                beginstep = laststep - maxsteps + 1
                if (beginstep < firststep) {
                    beginstep = firststep
                }
                endstep = laststep
            }

            // display firststep link when beginstep is not firststep
            if (beginstep > firststep) {
                linkParams.offset = 0
                writer << '<li>'
                writer << link(linkTagAttrs.clone()) {firststep.toString()}
                writer << '</li>'
                writer << '<li class="disabled"><a href="#">...</a></li>'
            }

            // display paginate steps
            (beginstep..endstep).each { i ->
                if (currentstep == i) {
                    writer << "<li class=\"active\">"
                    writer << link(linkTagAttrs.clone()) {i.toString()}
                    writer << "</li>";
                }
                else {
                    linkParams.offset = (i - 1) * max
                    writer << "<li>";
                    writer << link(linkTagAttrs.clone()) {i.toString()}
                    writer << "</li>";
                }
            }

            // display laststep link when endstep is not laststep
            if (endstep < laststep) {
                writer << '<li class="disabled"><a href="javascript:void(0)">...</a></li>'
                linkParams.offset = (laststep - 1) * max
                writer << '<li>'
                writer << link(linkTagAttrs.clone()) { laststep.toString() }
                writer << '</li>'
            }
        }

        // display next link when not on laststep
        if (currentstep < laststep) {
            linkParams.offset = offset + max
            writer << '<li class="next">'
            writer << link(linkTagAttrs.clone()) {
                (attrs.next ? attrs.next : messageSource.getMessage('paginate.next', null, messageSource.getMessage('default.paginate.next', null, 'Next', locale), locale))
            }
            writer << '</li>'
        }
        else {
            if (laststep > 1) {
                linkParams.offset = offset + max
                writer << '<li class="next disabled">'
                writer << """<a href="javascript:void(0)">${(attrs.next ? attrs.next : messageSource.getMessage('paginate.next', null, messageSource.getMessage('default.paginate.next', null, 'Next', locale), locale))}</a>"""
                writer << '</li>'
            }
        }

        writer << '</ul></div>'
    }

}
