package org.gualdi.grails.plugins.cms.domain

import org.grails.taggable.Taggable

class NewsItem implements Taggable, Serializable {
  Site site

  Date date
  String title
  String description
  String image
  String body
  String size
  Boolean highlight = false

  static constraints = {
    date(nullable: false)
    title(nullable: false, blank: false, maxSize: 100)
    description(nullable: true, blank: true, maxSize: 255)
    image(nullable: true, blank: true, maxSize: 255)
    body(nullable: false, blank: false)
    size(nullable: true, blank: true, inList: ['SMALL', 'MEDIUM', 'LARGE'])
    highlight(nullable: false)
  }

  static mapping = {
    columns {
      body type: 'text'
    }
  }
}
