package org.gualdi.grails.plugins.cms

import org.gualdi.grails.plugins.cms.co.CmsSitesCommand

class SitesControllerMixin {

    def cmsBaseService

    static menuEntry = [
        key: "cms.menu.sites",
        order: 20,
        useSitetag: false,
        items: [
            [key: 'cms.menu.sites.list', action: 'listSites'],
            [key: 'cms.menu.sites.add', action: 'addSite']
        ]
    ]

    def listSites() {
        def sites = cmsBaseService.listSites()

        render view: "/cms/sites/list", model:[list: sites]
    }

    def selectSite() {
        def sitetag = params.id
        flash.message = "cms.sites.message.siteSelected"
        redirect action: "managePages", params:[sitetag: sitetag]
    }

    def addSite() {
        CmsSitesCommand cmd = new CmsSitesCommand()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.saveSite(cmd)

                flash.message = "cms.sites.message.siteSaved"
                redirect action: "listSites"
            }
            else {
                render view: "/cms/sites/add", model: [cmd: cmd]
            }
        }
        else {
            render view: "/cms/sites/add", model: [cmd: cmd]
        }
    }

    def editSite() {
        CmsSitesCommand cmd = new CmsSitesCommand()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.updateSite(cmd)

                flash.message = "cms.sites.message.siteUpdated"
                redirect action: "listSites"
            }
            else {
                render view: "/cms/sites/edit", model: [cmd: cmd]
            }
        }
        else {
            def site = cmsBaseService.getSite(params.long("id"))
            bindData(cmd, site.properties)
            cmd.id = site.id
            render view: "/cms/sites/edit", model: [cmd: cmd]
        }
    }

    def deleteSite() {
        def id = params.long("id")

        cmsBaseService.deleteSite(id)

        flash.message = "cms.sites.message.siteDeleted"
        redirect action: "listSites"
    }

    def cancelSite() {
        redirect action: "listSites"
    }
}
