import org.gualdi.grails.plugins.cms.editor.CustomDateEditor
import org.gualdi.grails.plugins.cms.editor.CustomPropertyEditorRegistrar
import org.gualdi.grails.plugins.cms.security.CmsSecurityImpl
import org.gualdi.grails.plugins.cms.view.CmsViewResolverImpl

class Ixcms2GrailsPlugin {

    def version = "0.11.1"

    def grailsVersion = "2.0 > *"
    def dependsOn = [:]
    def pluginExcludes = [
            "grails-app/views/error.gsp"
    ]

    def title = "Ixcms2 Plugin"
    def author = "Stefano Gualdi"
    def authorEmail = "stefano.gualdi@gmail.com"
    def description = '''\
Internal simple CMS.
'''

    // URL to the plugin's documentation
    def documentation = "http://gualdi.org/plugin/ixcms2"

    // Uploaded file filter must be loaded after spring security
	def getWebXmlFilterOrder() {
        def FilterManager = getClass().getClassLoader().loadClass('grails.plugin.webxml.FilterManager')
        [ Ixcms2UploadedFileFilter: FilterManager.URL_MAPPING_POSITION + 10000 ]
    }

    def doWithWebDescriptor = { xml ->
        def filters = xml.filter[0]
        filters + {
            'filter' {
                'filter-name'("Ixcms2UploadedFileFilter")
                'filter-class'("org.gualdi.grails.plugins.cms.filter.UploadedFileFilter")
            }
        }

        def filterMappings = xml."filter-mapping"
        def lastMapping = filterMappings[filterMappings.size() - 1]
        lastMapping + {
            'filter-mapping' {
                'filter-name'("Ixcms2UploadedFileFilter")
                'url-pattern'("/*")
            }
        }
    }

    def doWithSpring = {
        // Register custom date editor
        customPropertyEditorRegistrar(CustomPropertyEditorRegistrar) {
            dateEditor = { CustomDateEditor e ->
                formats = ['dd/MM/yyyy HH:mm', 'dd/MM/yyyy']
                allowEmpty = true
            }
        }

        // Register the security service
        cmsSecurityService(CmsSecurityImpl)

        // Register the view resolver
        cmsViewResolverService(CmsViewResolverImpl)
    }

    def doWithDynamicMethods = { ctx ->
        // TODO Implement registering dynamic methods to classes (optional)
    }

    def doWithApplicationContext = { applicationContext ->
        // TODO Implement post initialization spring config (optional)
    }

    def onChange = { event ->
        // TODO Implement code that is executed when any artefact that this plugin is
        // watching is modified and reloaded. The event contains: event.source,
        // event.application, event.manager, event.ctx, and event.plugin.
    }

    def onConfigChange = { event ->
        // TODO Implement code that is executed when the project configuration changes.
        // The event is the same as for 'onChange'.
    }

    def onShutdown = { event ->
        // TODO Implement code that is executed when the application shuts down (optional)
    }
}
