package org.gualdi.grails.plugins.cms.view

import org.apache.commons.logging.LogFactory
import org.springframework.context.ApplicationContext
import org.springframework.context.ApplicationContextAware

class CmsViewResolverImpl implements CmsViewResolverInterface, ApplicationContextAware {
	final log = LogFactory.getLog(CmsViewResolverImpl)

    def cmsViewResolverBridge
    ApplicationContext applicationContext

    // Setup
    void setApplicationContext(ApplicationContext context) {
        this.@applicationContext = context
        if (context.containsBean('cmsViewResolverBridge')) {
            cmsViewResolverBridge = context.getBean('cmsViewResolverBridge')
        }
    }

    // Access the bridge
    CmsViewResolverInterface getBridge(boolean throwIfNone = false) {
        if (!cmsViewResolverBridge) {
            def msg = "A security bridge must be provided by the application!!!"
            if (throwIfNone) {
                throw new IllegalArgumentException(msg)
            } else if (log.warnEnabled) {
                log.warn msg
            }
        }
        cmsViewResolverBridge
    }

    // Methods implemented by the bridge as specified in CmsSecurity interface
    String getView(String sitetag, String action, request) {
    	if (cmsViewResolverBridge) {
    		return getBridge()?.getView(sitetag, action, request)
    	}
    	else {
    		return "${sitetag}/${action}"
    	}
	}
}
