package org.gualdi.grails.plugins.cms.filter

import org.springframework.web.context.support.WebApplicationContextUtils
import javax.servlet.*

class UploadedFileFilter implements Filter {
	
	def cmsContentService
	def cmsSecurityService
	def uploadURI
	def uploadTypes

	void init(FilterConfig config) throws ServletException {
        def applicationContext = WebApplicationContextUtils.getWebApplicationContext(config.servletContext)
		
		cmsContentService = applicationContext.cmsContentService
		cmsSecurityService = applicationContext.cmsSecurityService
		
		uploadURI = cmsContentService.getUploadUrl()
		uploadTypes = cmsContentService.getUploadTypes()
	}

	void destroy() {
	}

	void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		def ruri = request.requestURI[request.contextPath.size()..-1]
        if (ruri.startsWith(uploadURI)) {
        	// Try to extract the uri components
        	def parts = ruri.split(/\//).findAll { it?.trim() != '' }
        	def sitetag = null
        	def categoryTags
        	if (!(parts[1] in uploadTypes)) {
        		sitetag = parts[1]
        		categoryTags = parts[3..-2]
        	}
        	else {
        		categoryTags = parts[2..-2]	
        	}
        	categoryTags = categoryTags.reverse()

        	def canView = cmsContentService.canUserViewFile(sitetag, categoryTags)
        	if (!canView) {
                response.sendError(503, "You do not have permission to view this resource")
                chain.doFilter(request, response)
                return
            }

            /*
            def f = cmsContentService.getUploadPath(ruri)
            if (!f.exists()) {
            	println f.absolutePath
            	println ">>>>>>>>>>>>>>>>>>>>>> NO FILE FOUND"
                response.sendError(404)
                return
            }
            */

			/*
			def mt = content ? content.mimeType : MimeUtils.getDefaultMimeType(f.name)

	        response.setContentType(mt)    
	        try {
	            // @todo is this fast enough?    
	            response.outputStream << f.newInputStream()
	        } catch (IOException ioe) {
	            // Munch. We should never do this but the client has gone away so...
	        }
			*/
        }

		chain.doFilter(request, response)
	}
}

