package org.gualdi.grails.plugins.cms.commands

import org.apache.commons.logging.LogFactory
import org.codehaus.groovy.grails.commons.ConfigurationHolder             

class CommandProcessor {
    static log = LogFactory.getLog("org.gualdi.grails.plugins.cms.commands.CommandProcessor")

    def cmd = null

    def process( commands ) {
        def result

        def tok = new StringTokenizer(commands)

        def commandDefinitions = ConfigurationHolder.config.cms.commands

        cmd = tok.nextToken()
        def cmdDef = commandDefinitions[cmd]
        if (cmdDef) {
            def controller = cmdDef.controller
            def action = cmdDef.action
            def paramNames = cmdDef.params

            def finalParams = [:]
            def tmpParams = []
            if (paramNames) {
                // Colleziona i parametri dai tokens
                while (tok.hasMoreTokens()) {
                    tmpParams << tok.nextToken()
                }

                // Accoppia i parametri creando una Map.
                // Viene estratto solo il numero di parametri specificato nella lista parametri del comando

                def idx = 0
                paramNames.each { p ->
                    finalParams[p] = tmpParams[idx]
                    idx++
                }

            }
            
            if (paramNames.size() != tmpParams.size() ) {
                log.error "Wrong number of parameters expected ${paramNames.size()} got ${tmpParams.size()}"
                result = null
            }
            else {
                result = [controller: controller, action: action, params: finalParams]
            }
        }
        else {
            log.error "Command ${cmd} not defined in config"
            result = null
        }

        return result
    }

    def getCommand() {
        return this.cmd
    }
}
