package org.gualdi.grails.plugins.cms.co

import org.gualdi.grails.plugins.cms.domain.Site
import grails.validation.Validateable
import org.springframework.context.ApplicationContext
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes

@Validateable
class CmsSitesCommand {

    // Inject service, needed because we are manually creating the command object
    ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
    def cmsBaseService = ctx.getBean('cmsBaseService')

    Long id
    String tag
    String name
    String title
    String meta
    String googleTag

    static constraints = {
        id nullable: true

        importFrom Site

        tag blank: true, nullable: true, maxSize: 50, matches: /[a-z0-9_-]*/, validator: { value, obj ->
            if (value) {
                if (!obj.cmsBaseService.isSiteTagUnique(value, obj.id)) {
                    return ['unique']
                }
            }
        }
    }
}
