package org.gualdi.grails.plugins.cms.co

import grails.validation.Validateable
import org.gualdi.grails.plugins.cms.domain.Category
import org.gualdi.grails.plugins.cms.domain.Page
import org.springframework.context.ApplicationContext
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes
import org.gualdi.grails.plugins.cms.commands.CommandProcessor

@Validateable
class CmsPagesCommand {

    // Inject service, needed because we are manually creating the command object
    ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
    def cmsBaseService = ctx.getBean('cmsBaseService')

    Long id
    Category category
    String tag
    String title
    String description
    String image
    String body
    String commands
    Boolean hidden = false
    Boolean preprocess = false
    Boolean commentEnabled = false

    String tags
    String sitetag

    def setTagsAsArray(txtTags) {
        this.tags = txtTags?.join(',')
    }

    def getTagsAsArray() {
        this.tags?.split(/,/).collect { it.trim() }
    }

    static constraints = {
        id nullable: true
        category bindable: true

        tag blank: true, nullable: true, maxSize: 50, matches: /[a-z0-9_-]*/, validator: { value, obj ->
            if (value) {
                if (!obj.cmsBaseService.isPageTagUnique(value, obj.sitetag, obj.id)) {
                    return ['unique']
                }
            }
        }

        commands(blank: true, nullable: true, validator: { value, obj ->
            if (value) {
                def cmd = new CommandProcessor()
                if ( !cmd.process(value) ) {
                    return ['invalid']
                }
            }
        })

        importFrom Page, exclude: ['tag', 'commands']

        tags nullable: true, blank: true
        sitetag nullable: true, blank: true
    }
}
