package org.gualdi.grails.plugins.cms.co

import grails.validation.Validateable
import org.gualdi.grails.plugins.cms.domain.NewsItem

@Validateable
class CmsNewsCommand {
    Long id
    Date date = new Date()
    String title
    String description
    String image
    String body
    String tags
    String size
    Boolean highlight

    def setTagsAsArray(txtTags) {
        this.tags = txtTags?.join(',')
    }

    def getTagsAsArray() {
        this.tags?.split(/,/).collect { it.trim() }
    }

    static constraints = {
        id nullable: true
        tags nullable: true, blank: true
        importFrom NewsItem
    }
}
