<r:require modules="form-utils"/>

<r:script>
    function openWindow(){
        window.open('${cmsadmin.fileBrowserLink(type:'image', fileBrowser:'ofm', showThumbs:'true')}', null, 'location=no,menubar=no,toolbar=no,dependent=yes,minimizable=no,modal=yes,alwaysRaised=yes,resizable=yes,scrollbars=yes,width=1066,height=525,top=112,left=133');
    }

    function ckeditorFileBrowserItemSelected(path) {
        $("#image").val(path);
    }

    $(function () {
        initTagsEditor('#tags', '${createLink(controller: 'cmsAdmin', action: 'tagsForPages', params: [sitetag: params.sitetag])}');
    });
</r:script>

<g:render template="/cms/common/richEditorConfig"/>

<f:with bean="${cmd}">
    <f:field property="tag" input-class="input-small"/>
    <f:field property="category">
        <g:select name="category.id" from="${categories}" optionKey="id" optionValue="htmlName" value="${cmd?.category?.id}" noSelection="['':'']"/>
    </f:field>
    <f:field property="title" input-class="input-xxlarge"/>

    <f:field property="description">
        <g:textArea name="${property}" value="${value}" rows="3" cols="10" class="input-xxlarge"/>
    </f:field>

    <f:field id="image" property="image">
        <div class="input-append">
            <g:textField name="${property}" value="${value}" class="input-xxlarge"/><a href="javascript:openWindow()"><span class="add-on"><i class="icon-camera"></i></span></a>
        </div>
    </f:field>

    <f:field property="tags">
        <input type="hidden" id="${property}" name="${property}" class="input-xxlarge" value="${value}"/>
    </f:field>
    <f:field property="body">
        <cmsadmin:richEditor name="${property}" toolbar="Ixcms2" width="98%" height="300">${value}</cmsadmin:richEditor>
    </f:field>

    <div class="control-group">
        <label class="control-label"><g:message code="cmsPagesCommand.flags.label"/></label>

        <div class="controls">
            <label class="checkbox">
                <g:checkBox name="hidden" value="${cmd?.hidden}"/>
                <g:message code="cmsPagesCommand.hidden.label"/>
            </label>
            <label class="checkbox">
                <g:checkBox name="preprocess" value="${cmd?.preprocess}"/>
                <g:message code="cmsPagesCommand.preprocess.label"/>
            </label>
            <label class="checkbox">
                <g:checkBox name="commentEnabled" value="${cmd?.commentEnabled}"/>
                <g:message code="cmsPagesCommand.commentEnabled.label"/>
            </label>
        </div>
    </div>

    <f:field property="commands" input-class="input-xxlarge"/>
</f:with>
