<%@ page contentType="text/html;charset=UTF-8" %>

<html>
    <head>
        <meta name="layout" content="ixcms2"/>
    </head>

    <body>
        <div class="page-header">
            <h1><g:message code="cms.news.title"/></h1>
        </div>

        <div class="row-fluid">

            <g:render template="/cms/news/actions"/>

            <div class="span9">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th style="width: 10%"><g:message code="cmsNewsCommand.date.label"/></th>
                        <th style="width: 10%"><g:message code="cmsNewsCommand.size.label"/></th>
                        <th style="width: 65%"><g:message code="cmsNewsCommand.title.label"/></th>
                        <th style="width: 15%">&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <g:each in="${list}" var="i">
                        <tr>
                            <td><g:formatDate date="${i.date}" format="dd/MM/yyyy"/></td>
                            <td><g:if test="${i.size}"><g:message code="cmsNewsCommand.size.${i.size}"/></g:if><g:else>&nbsp;</g:else></td>
                            <td>${i.title}</td>
                            <td>
                                <div class="btn-group">
                                    <g:link action="editNews" id="${i.id}" params="[sitetag: params.sitetag]" class="btn btn-primary"><g:message code="cms.button.edit"/></g:link>
                                    <button class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a href="javascript:void(0)" class="delete-button" data-row-id="${i.id}"><i class="icon-trash"></i> <g:message code="cms.button.delete"/>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    </g:each>
                    </tbody>
                </table>

                <cmsadmin:paginate total="${list.totalCount}" params="[sitetag: params.sitetag]"/>
            </div>

            <div class="span1">
                &nbsp;
            </div>
        </div>

        <g:render template="/cms/common/dialogs/deleteDialog" model="[controller: 'cmsAdmin', action: 'deleteNews', params: [sitetag: params.sitetag], dialogTitle: message(code: 'cms.news.dialog.delete.title'), dialogBody: message(code: 'cms.news.dialog.delete.body'), dialogId: 'delete-dialog', buttonClass:'delete-button']"/>
    </body>
</html>