package org.gualdi.grails.plugins.cms

import grails.util.Environment

import org.gualdi.grails.plugins.cms.domain.*

/*
    TagLib for use by the host app
*/
class Ixcms2TagLib {

    static namespace = "cms"

    def cmsBaseService
    def cmsSecurityService
    def cmsContentService

    // ======================================================================
    // Banners
    // ======================================================================

    def banners = { attrs ->
        def sitetag = attrs.site
        def tag = attrs.tag
        if (!tag) {
            def position = attrs.position
            def bns = cmsBaseService.listBannersByPosition(sitetag, position, [max: 999])
            bns.each { banner ->
                out << banner.body
            }
        }
        else {
            def banner = cmsBaseService.getBannerByTag(sitetag, tag)
            if (banner) {
                out << banner.body
            }
            else {
                out << "ERROR: banner ${tag} not defined!"
            }
        }
    }

    def banner = { attrs, body ->
        def sitetag = attrs.site
        def tag = attrs?.tag
        def position = attrs?.position
        def positionSelector = attrs?.selector
        def template = attrs?.template
        def max = attrs?.max
        def var = attrs?.var ?: 'b'
        def status = attrs?.status ?: 'i'

        Site site = Site.findByTag(sitetag)

        if (max) {
        	max = Math.min(max ? max.toInteger() : 10, 100)
        }

        def c = Banner.createCriteria()

        def results
        if (tag) {
            results = c.list {
                and {
                    eq("site", site)
                    eq("tag", tag)
                }
            }
        }
        else {
            results = c.list {
            	and {
    	            eq("site", site)
    	            eq('active', true)
    	            if (position) {
    	                eq("position", position)
    	            }
    	            if (positionSelector) {
    	                eq("positionSelector", positionSelector)
    	            }
            	}

            	if (max) {
            		maxResults(max)
            	}

                order("ordine", "asc")
            }
        }

        int counter = 0
        results.each { n ->
            if (template) {
                out << render(template: template, model: [(var): n, (status): counter])
            }
            else
            {
                out << body((var): n, (status): counter)
            }
            counter++;
        }
    }

    // ======================================================================
    // Breadcrumb
    // ======================================================================

    def breadcrumb = { attrs, body ->
    	def sitetag = attrs.site
    	def page = attrs.page
    	def includePage = attrs?.includePage == "true" ? true : false
    	def home = attrs.home
    	def divider = attrs?.divider ?: '/'
    	def var = attrs?.var ?: 'name'

		def outBuf = "" << ""

    	if (page) {
    		def results = []
	    	breadcrumbImpl(page.category, results)
	    	results = results.reverse()

	    	if (includePage) {
	    		results << page.title
	    	}

			def size = results.size()

	    	if (home) {
	    		outBuf << "<li>"
		        outBuf << "<a href=\"${createLink(controller: 'cmsContent', action: 'index', params: [site: sitetag])}\">${home}</a>"
				if (size) {
					outBuf << """<span class="divider">${divider}</span>"""
				}
		        outBuf << "</li>\n"
	        }

	    	if (page) {
		    	results.each { name ->
		    		size--
		    		outBuf << body((var): name, divider: divider, last: (size == 0))
		    	}
	    	}
	    }

    	out << outBuf
    }

    private breadcrumbImpl(category, results) {
    	if (!category.hidden) {
    		results << category.name
    	}
    	if (category.parent) {
    		breadcrumbImpl(category.parent, results)
    	}
    }

    // ======================================================================
    // News
    // ======================================================================

    def news = { attrs, body ->
        def sitetag = attrs.site
        def size = attrs?.size
        def max = attrs?.max ?: "5"
        def template = attrs?.template
        def highlighted = attrs?.highlighted == 'true' ? true : false
        def var = attrs?.var ?: 'n'

        Site site = Site.findByTag(sitetag)

        max = Math.min(max ? max.toInteger() : 10, 100)

        def c = NewsItem.createCriteria()
        def results = c.list(max: max) {
            eq("site", site)
            if (size) {
                eq("size", size)
            }
            if (highlighted) {
              eq("highlight", true)
            }
            order("date", "desc")
        }

        results.each { n ->
            if (template) {
                out << render(template: template, model: [(var): n])
            }
            else
            {
                out << body((var): n)
            }
        }
    }

    // ======================================================================
    // Categories
    // ======================================================================

    def categories = { attrs, body ->
        def sitetag = attrs.site
        def categoryId = attrs.category
        def template = attrs?.template
        def var = attrs?.var ?: 'c'

        def result = cmsContentService.getCategory(categoryId, sitetag)
        def results = result.children

        results.each { n ->
            if (template) {
                out << render(template: template, model: [(var): n])
            }
            else
            {
                out << body((var): n)
            }
        }

    }

    // ======================================================================
    // Twitter Bootstrap menu
    // ======================================================================

    def renderBootstrapMenu = { attrs ->
        def sitetag = attrs.site
        def home = attrs.home
        def cls = attrs.'class' ?: "nav"

        // We are providing the roles' based key to use the cacheable version
        def userRoles = cmsSecurityService.currentUserRoles
        def rolesKey = sitetag + "#" + (userRoles.size() > 0 ? userRoles.sort().join("#") : 'unprotected')
        def struct = cmsBaseService.getSiteStructureForCurrentUser(sitetag, rolesKey)

        def result = "" << ""
        renderBootstrapMenuImpl(sitetag, struct, 0, result)

        def menu = "" << ""
        menu << """<ul class="${cls}">\n"""

        if (home) {
            menu << "<li><a href=\"${createLink(controller: 'cmsContent', action: 'index', params: [site: sitetag])}\">${home}</a></li>\n"
        }

        menu << result
        menu << "</ul>\n"

        out << menu
    }

    private renderBootstrapMenuImpl(sitetag, struct, level, result) {
        for (item in struct) {
            if (!item.hidden) {
                if (item.type == 'category') {
                    if (item?.children?.size() > 0 && item?.children?.any { !it.hidden }) {
                        result << """<li class=${level == 0 ? 'dropdown' : 'dropdown-submenu'}>\n"""
                        result << """<a href="${getLinkForItem(item, sitetag)}" class="dropdown-toggle" data-toggle="dropdown">${item.name}${level == 0 ? '<b class="caret"></b>' : ''}</a>\n"""
                        result << """<ul class="dropdown-menu">\n"""
                        renderBootstrapMenuImpl(sitetag, item.children, level + 1, result)
                        result << "</ul>\n"
                        result << "</li>\n"
                    }
                    else {
                        result << "<li>"
                        result << """<a href="${getLinkForItem(item, sitetag)}">${item.name}</a>\n"""
                        result << "</li>"
                    }
                }
                else {
                    result << "<li>"
                    result << """<a href="${getLinkForItem(item, sitetag)}">${item.name}</a>\n"""
                    result << "</li>"
                }
            }
        }
    }

    private getLinkForItem(item, sitetag) {
        def result = ""

        if (item.type == 'category') {
            if (item.pageTag) {
                result = g.createLink(controller: "cmsContent", action: "show", id: item.pageTag ?: item.objId, params: [site: sitetag])
            }
            else {
                result = "javascript:void(0);"
            }
        }
        else {
            result = g.createLink(controller: "cmsContent", action: "show", id: item.tag ?: item.objId, params: [site: sitetag])
        }

        return result
    }

    // ======================================================================
    // Google analytics
    // ======================================================================

    /*
    Note: put the tag before the closing <head>
    */
    def googleAnalytics = { attrs ->
        // Only enabled in production
        if (Environment.current == Environment.PRODUCTION) {
            def sitetag = attrs.site
            def googleCode = cmsBaseService.getGoogleAnalyticsCode(sitetag)

            if (googleCode) {
                out << """
<script type="text/javascript">
  var _gaq = _gaq || [];
  _gaq.push(['_setAccount', '${googleCode}']);
  _gaq.push(['_trackPageview']);

  (function() {
    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
  })();
</script>
"""
            }
        }
    }
}
