package org.gualdi.grails.plugins.cms.domain

class Category implements Serializable {
  static belongsTo = [site: Site, parent: Category]
  static hasMany = [pages: Page, categories: Category]

  String name
  String pageTag
  String description
  String image
  Boolean hidden = false
  Integer ordine = 0
  String role
  String protectionTag

  def getRootSite() {
    def s = this.site ?: getRootSiteImpl(this?.parent)
    return s
  }

  private getRootSiteImpl(category) {
    def tmp = category
    def site = tmp.site
    while (!site) {
      tmp = tmp.parent
      site = tmp.site
    }

    return site
  }

  def getVisibleCategories() {
    this.categories?.findAll { c -> !c.hidden }?.sort { a, b -> a.ordine == b.ordine ? a.name <=> b.name : a.ordine <=> b.ordine }
  }

  def getVisiblePages() {
    this.pages?.findAll { p -> !p.hidden }?.sort { a, b -> a.ordine == b.ordine ? a.title <=> b.title : a.ordine <=> b.ordine }
  }

  def getSortedCategories() {
    return this.categories?.sort { a, b -> a.ordine == b.ordine ? a.name <=> b.name : a.ordine <=> b.ordine }
  }

  def getSortedPages() {
    return this.pages?.sort { a, b -> a.ordine == b.ordine ? a.title <=> b.title : a.ordine <=> b.ordine }
  }

  def getVisible() {
    return !hidden
  }

  def isVisibleForRoles(activeUserRoles) {
    def result = true
    def item = this
    while (item && result) {
      def categoryRole = item.role != null && item.role != 'null' ? item.role : null
      if (categoryRole) {
        result = categoryRole in activeUserRoles
      }
      item = item.parent
    }

    return result
  }

  static constraints = {
    parent(nullable: true)
    site(nullable: true)
    name(blank: false, maxSize: 255)
    pageTag(nullable: true, blank: true, maxSize: 50)
    description(nullable: true, blank: true, maxSize: 255)
    image(nullable: true, blank: true, maxSize: 255)
    hidden(nullable: true, blank: true)
    ordine(nullable: true, blank: false)
    role(nullable: true, blank: true)
    protectionTag(nullable: true, blank: true, maxSize: 50)
  }
}
