package org.gualdi.grails.plugins.cms

class CmsContentController extends CmsBaseContentController {

    def cmsContentService
    def cmsViewResolverService

    def index() {
        def config = grailsApplication.config

        def defaultSite = config.cms.site.defaultSite
        def defaultPage = config.cms.site.defaultPage
        def sitetag = params.site ?: defaultSite
        def id = params.tag ?: defaultPage
        redirect(action: 'show', params: [site: sitetag, id: id])
    }

    def showCategory() {
    	def c = cmsContentService.getCategory(params.id, params.site)
        if (c.error) {
            sendError(c.errorCode, params)
        }
        else {
        	def view = cmsViewResolverService.getView(c.site.tag, "category", request)
            render(view: view, model: c)
        }
    }

    def show() {
        def p = cmsContentService.getPage(params.id, params.site)
        if (p.error) {
            sendError(p.errorCode, params)
        }
        else if (p.command) {
            redirect(url: p.command)
        }
        else {
            // FIXME: preprocessed pages must be implemented!!!
            if (p.page.preprocess) {
                p['processedBody'] = cmsContentService.processTemplate(p.page, p)
            }
            else {
                p['processedBody'] = p.page.body
            }
            
        	def view = cmsViewResolverService.getView(p.site.tag, "show", request)
            render(view: view, model: p)
        }
    }
}
