package org.gualdi.grails.plugins.cms

import grails.converters.JSON
import org.gualdi.grails.plugins.cms.domain.Page
import org.gualdi.grails.plugins.cms.co.CmsCategoriesCommand
import org.gualdi.grails.plugins.cms.co.CmsPagesCommand

class PagesControllerMixin {

    def cmsBaseService
    def cmsSecurityService

    static menuEntry = [
            key: "cms.menu.pages",
            order: 30,
            useSitetag: true,
            items: [
                    [key: 'cms.menu.pages.manage', action: 'managePages'],
            ]
    ]

    // =====================================================================
    // Overall management
    // =====================================================================

    def managePages() {
        render view: "/cms/pages/manage"
    }

    def siteStructure() {
        def sitetag = params.sitetag
        def structure = cmsBaseService.getSiteStructure(sitetag)

        render structure as JSON
    }

    def siteObject() {
        def id = params.long("id")
        def type = params.type

        def obj = cmsBaseService.getSiteObject(id, type)

        render obj as JSON
    }

    def moveObject() {
        def info = JSON.parse(params.info)

        def status = cmsBaseService.moveObject(info);

        def result = [
                status: status ? 'success' : 'error'
        ]

        render result as JSON
    }

    // =====================================================================
    // Categories management
    // =====================================================================

    def addCategory() {
        def sitetag = params.sitetag

        CmsCategoriesCommand cmd = new CmsCategoriesCommand()
        cmd.sitetag = sitetag

        def categories = cmsBaseService.listCategoriesFlat(sitetag)
        def taggedPages = cmsBaseService.listTaggedPages(sitetag)
        def roles = cmsSecurityService.getAllRoles()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.saveCategory(cmd, sitetag)

                flash.message = "cms.categories.message.categorySaved"
                redirect action: "managePages", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/pages/categories/add", model: [cmd: cmd, categories: categories, taggedPages: taggedPages, roles: roles]
            }
        }
        else {
            if (params.id) {
                def category = cmsBaseService.getCategory(params.long("id"))
                cmd.parent = category
            }
            render view: "/cms/pages/categories/add", model: [cmd: cmd, categories: categories, taggedPages: taggedPages, roles: roles]
        }
    }

    def editCategory() {
        def sitetag = params.sitetag

        CmsCategoriesCommand cmd = new CmsCategoriesCommand()
        cmd.sitetag = sitetag

        def categories = cmsBaseService.listCategoriesFlat(sitetag, params.long("id"))
        def taggedPages = cmsBaseService.listTaggedPages(sitetag)
        def roles = cmsSecurityService.getAllRoles()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.updateCategory(cmd, sitetag)

                flash.message = "cms.categories.message.categoryUpdated"
                redirect action: "managePages", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/pages/categories/edit", model: [cmd: cmd, categories: categories, taggedPages: taggedPages, roles: roles]
            }
        }
        else {
            def category = cmsBaseService.getCategory(params.long("id"))
            bindData(cmd, category.properties)
            cmd.id = category.id
            render view: "/cms/pages/categories/edit", model: [cmd: cmd, categories: categories, taggedPages: taggedPages, roles: roles]
        }
    }

    def deleteCategory() {
        def sitetag = params.sitetag
        def id = params.long("id")

        cmsBaseService.deleteCategory(id)

        flash.message = "cms.categories.message.categoryDeleted"
        redirect action: "managePages", params: [sitetag: sitetag]
    }

    def cancelCategory() {
        redirect action: "managePages", params: [sitetag: params.sitetag]
    }

    // =====================================================================
    // Pages management
    // =====================================================================

    def addPage() {
        def sitetag = params.sitetag

        CmsPagesCommand cmd = new CmsPagesCommand()
        cmd.sitetag = sitetag

        def categories = cmsBaseService.listCategoriesFlat(sitetag)

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.savePage(cmd, sitetag)

                flash.message = "cms.pages.message.pageSaved"
                redirect action: "managePages", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/pages/pages/add", model: [cmd: cmd, categories: categories]
            }
        }
        else {
            if (params.id) {
                def category = cmsBaseService.getCategory(params.long("id"))
                cmd.category = category
            }
            render view: "/cms/pages/pages/add", model: [cmd: cmd, categories: categories]
        }
    }

    def editPage() {
        def sitetag = params.sitetag

        CmsPagesCommand cmd = new CmsPagesCommand()
        cmd.sitetag = sitetag

        def categories = cmsBaseService.listCategoriesFlat(sitetag)

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.updatePage(cmd)

                flash.message = "cms.pages.message.pageUpdated"
                redirect action: "managePages", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/pages/pages/edit", model: [cmd: cmd, categories: categories]
            }
        }
        else {
            def page = cmsBaseService.getPage(params.long("id"))
            bindData(cmd, page.properties, [exclude: ['tags']])
            cmd.id = page.id
            cmd.setTagsAsArray(page.tags)
            render view: "/cms/pages/pages/edit", model: [cmd: cmd, categories: categories]
        }
    }

    def deletePage() {
        def sitetag = params.sitetag
        def id = params.long("id")

        cmsBaseService.deletePage(id)

        flash.message = "cms.pages.message.pageDeleted"
        redirect action: "managePages", params: [sitetag: sitetag]
    }

    def cancelPage() {
        redirect action: "managePages", params: [sitetag: params.sitetag]
    }

    def tagsForPages() {
        def tags = cmsBaseService.getTagsFor(Page, params.q)

        render tags as JSON
    }

    // =====================================================================
    // Utilities
    // =====================================================================
}
