package org.gualdi.grails.plugins.cms

import grails.converters.JSON
import org.gualdi.grails.plugins.cms.co.CmsNewsCommand
import org.gualdi.grails.plugins.cms.domain.NewsItem

class NewsControllerMixin {

    def cmsBaseService

    static menuEntry = [
            key: "cms.menu.news",
            order: 40,
            useSitetag: true,
            items: [
                    [key: 'cms.menu.news.list', action: 'listNews'],
                    [key: 'cms.menu.news.add', action: 'addNews']
            ]
    ]

    def listNews() {
        def sitetag = params.sitetag
        def news = cmsBaseService.listNews(sitetag, params)

        render view: "/cms/news/list", model: [list: news]
    }

    def addNews() {
        def sitetag = params.sitetag

        CmsNewsCommand cmd = new CmsNewsCommand()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.saveNews(cmd, sitetag)

                flash.message = "cms.news.message.newsSaved"
                redirect action: "listNews", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/news/add", model: [cmd: cmd]
            }
        }
        else {
            render view: "/cms/news/add", model: [cmd: cmd]
        }
    }

    def editNews() {
        def sitetag = params.sitetag

        CmsNewsCommand cmd = new CmsNewsCommand()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.updateNews(cmd)

                flash.message = "cms.news.message.newsUpdated"
                redirect action: "listNews", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/news/edit", model: [cmd: cmd]
            }
        }
        else {
            def news = cmsBaseService.getNews(params.long("id"))
            bindData(cmd, news.properties, [exclude: ['tags']])
            cmd.id = news.id
            cmd.setTagsAsArray(news.tags)
            render view: "/cms/news/edit", model: [cmd: cmd]
        }
    }

    def deleteNews() {
        def sitetag = params.sitetag
        def id = params.long("id")

        cmsBaseService.deleteNews(id)

        flash.message = "cms.news.message.newsDeleted"
        redirect action: "listNews", params: [sitetag: sitetag]
    }

    def cancelNews() {
        redirect action: "listNews", params: [sitetag: params.sitetag]
    }

    def tagsForNews() {
        def tags = cmsBaseService.getTagsFor(NewsItem, params.q)

        render tags as JSON
    }
}
