package org.gualdi.grails.plugins.cms

import org.gualdi.grails.plugins.cms.co.CmsBannersCommand

class BannersControllerMixin {

    def cmsBaseService

    static menuEntry = [
            key: "cms.menu.banners",
            order: 50,
            useSitetag: true,
            items: [
                    [key: 'cms.menu.banners.list', action: 'listBanners'],
                    [key: 'cms.menu.banners.add', action: 'addBanner']
            ]
    ]

    def listBanners() {
        def sitetag = params.sitetag
        def banners = cmsBaseService.listBanners(sitetag, params)

        render view: "/cms/banners/list", model: [list: banners]
    }

    def addBanner() {
        def sitetag = params.sitetag

        CmsBannersCommand cmd = new CmsBannersCommand()

        def taggedPages = cmsBaseService.listTaggedPages(sitetag)

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.saveBanner(cmd, sitetag)

                flash.message = "cms.banners.message.bannerSaved"
                redirect action: "listBanners", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/banners/add", model: [cmd: cmd, taggedPages: taggedPages]
            }
        }
        else {
            render view: "/cms/banners/add", model: [cmd: cmd, taggedPages: taggedPages]
        }
    }

    def editBanner() {
        def sitetag = params.sitetag

        CmsBannersCommand cmd = new CmsBannersCommand()

        def taggedPages = cmsBaseService.listTaggedPages(sitetag)

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseService.updateBanner(cmd)

                flash.message = "cms.banners.message.bannerUpdated"
                redirect action: "listBanners", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/banners/edit", model: [cmd: cmd, taggedPages: taggedPages]
            }
        }
        else {
            def banner = cmsBaseService.getBanner(params.long("id"))
            bindData(cmd, banner.properties)
            cmd.id = banner.id
            render view: "/cms/banners/edit", model: [cmd: cmd, taggedPages: taggedPages]
        }
    }

    def deleteBanner() {
        def sitetag = params.sitetag
        def id = params.long("id")

        cmsBaseService.deleteBanner(id)

        flash.message = "cms.banners.message.bannerDeleted"
        redirect action: "listBanners", params: [sitetag: sitetag]
    }

    def cancelBanner() {
        redirect action: "listBanners", params: [sitetag: params.sitetag]
    }
}

