package org.gualdi.grails.plugins.cms.co

import grails.validation.Validateable
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes
import org.springframework.context.ApplicationContext

@Validateable
class CmsUsersRolesCommand {

    // Inject service, needed because we are manually creating the command object
    ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
    def cmsBaseUsersService = ctx.getBean('cmsBaseUsersService')

    Set<String> users
    Set<String> roles

    static constraints = {
        users validator: { value, obj ->
        	if (!obj.users || obj.users?.size() == 0) {
        		return ['blank']
        	}
        }
        roles validator: { value, obj ->
        	if (!obj.roles || obj.roles?.size() == 0) {
        		return ['empty']
        	}
        }
    }
}
