package org.gualdi.grails.plugins.cms.co

import grails.validation.Validateable
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes
import org.springframework.context.ApplicationContext

@Validateable
class CmsUsersCommand {

    // Inject service, needed because we are manually creating the command object
    ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
    def cmsBaseUsersService = ctx.getBean('cmsBaseUsersService')

    Long id
    String name
    String surname
    String email
    String username
    String password
    Boolean enabled = true
    Boolean accountLocked = false
    Boolean accountExpired = false
    Boolean passwordExpired = false
    Set<String> roles

    static constraints = {
        id nullable: true
        name blank: false
        surname blank: false
        email email: true, blank: false

        // Validate only if new user
        username nullable: false, blank: false, validator: { value, obj ->
            if (value) {
                if (!obj.cmsBaseUsersService.isUsernameUnique(value, obj.id)) {
                    return ['unique']
                }
            }
        }

        // Validate only if new user
        password validator: { value, obj ->
            if (!obj.id && !value) {
                return ['blank']
            }
        }

        enabled nullable: true
        accountLocked nullable: true
        accountExpired nullable: true
        passwordExpired nullable: true

        roles nullable: true
    }

}
