package org.gualdi.grails.plugins.cms.co

import grails.validation.Validateable
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes
import org.springframework.context.ApplicationContext

@Validateable
class CmsRolesCommand {

    // Inject service, needed because we are manually creating the command object
    ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
    def cmsBaseUsersService = ctx.getBean('cmsBaseUsersService')

    Long id
    String authority

    static constraints = {
        id nullable: true
        authority blank: false

        /*
        // Validate only if new user
        username nullable: false, blank: false, validator: { value, obj ->
            if (value) {
                if (!obj.cmsBaseUsersService.isUsernameUnique(value, obj.id)) {
                    return ['unique']
                }
            }
        }
        */
    }
}
