<%@ page contentType="text/html;charset=UTF-8" %>

<html>
    <head>
        <meta content="ixcms2" name="layout">

        <r:require modules="form-utils"/>

        <r:script>
		    $(function () {
		        $("#roles").select2({
		            multiple: true,
		            minimumInputLength: 1,
		            ajax: {
		                url: "${createLink(controller: 'cmsAdmin', action:'listAllRoles', params:['sitetag': params.sitetag, excludeAdmins: true])}",
		                dataType: 'json',
		                data: function (term, page) {
		                    return {
		                        q: term,
		                    };
		                },
		                results: function (data, page) { 
		                    var ref = [];
		                    $.each(data, function(idx, itm) {
		                    	ref.push({id: itm.id, text: itm.authority})
		                	});
		                	return {results: ref};
		                }
		            }
		        });

		        $("#users").select2({
		            multiple: true,
		            minimumInputLength: 1,
		            ajax: {
		                url: "${createLink(controller: 'cmsAdmin', action:'listAllUsers', params:['sitetag': params.sitetag])}",
		                dataType: 'json',
		                data: function (term, page) {
		                    return {
		                        q: term,
		                    };
		                },
		                results: function (data, page) { 
		                    var ref = [];
		                    $.each(data, function(idx, itm) {
		                    	ref.push({id: itm.id, text: itm.name + " " + itm.surname + " (" + itm.username + ")"})
		                	});
		                    return {results: ref};
		                }
		            }
		        });
		    });
		</r:script>
    </head>

    <body>
        <div class="page-header">
            <h1><g:message code="cms.users.title"/></h1>
        </div>

        <div class="row-fluid">
            <g:render template="/cms/users/actions"/>

            <div class="span9">
                <g:form name="assign-form" action="assignUsers" params="[sitetag: params.sitetag]" class="form-horizontal" novalidate="">
                    <f:field property="roles">
                    	<g:textField id="${property}" name="${property}" value="${value}" class="input-xxlarge"/>
    				</f:field>

                    <f:field property="users">
						<g:textField id="${property}" name="${property}" value="${value}" class="input-xxlarge"/>   
    				</f:field>

                    <div class="form-actions">
                        <g:actionSubmit class="btn btn-primary" action="assignUsers" value="${message(code: 'cms.button.update')}"/>
                        <g:actionSubmit class="btn" action="cancelUser" value="${message(code: 'cms.button.cancel')}"/>
                    </div>
                </g:form>
            </div>
        </div> <!-- // row -->
    </body>
</html>
