<r:require modules="form-utils"/>

<r:script>
    $(function () {
        $("#roles").select2();
    });
</r:script>

<g:hiddenField name="id" value="${cmd.id}"/>

<f:with bean="${cmd}">
    <f:field property="name" input-class="span6"/>
    <f:field property="surname" input-class="span6"/>

    <g:if test="${cmd?.id}">
        <g:hiddenField name="username" value="${cmd?.username}"/>
        <f:display property="username"/>
    </g:if>
    <g:else>
        <f:field property="username" input-class="span4"/>
    </g:else>

    <f:field property="password">
        <g:passwordField name="${property}" value="${value}"/>
    </f:field>

    <div class="control-group">
        <label class="control-label"><g:message code="cmsUsersCommand.flags.label"/></label>
        <div class="controls">
            <label class="checkbox">
                <g:checkBox name="enabled" value="${cmd?.enabled}"/>
                <g:message code="cmsUsersCommand.flags.enabled.label"/>
            </label>
            <label class="checkbox">
                <g:checkBox name="accountLocked" value="${cmd?.accountLocked}"/>
                <g:message code="cmsUsersCommand.flags.accountLocked.label"/>
            </label>
            <label class="checkbox">
                <g:checkBox name="accountExpired" value="${cmd?.accountExpired}"/>
                <g:message code="cmsUsersCommand.flags.accountExpired.label"/>
            </label>
            <label class="checkbox">
                <g:checkBox name="passwordExpired" value="${cmd?.passwordExpired}"/>
                <g:message code="cmsUsersCommand.flags.passwordExpired.label"/>
            </label>
        </div>
    </div>
    
    <f:field property="email" input-class="span6"/>
    
    <f:field property="roles">
        <g:select id="roles" name="roles" value="${value}" from="${allRoles}" optionKey="authority" optionValue="authority" multiple="yes" class="input-xxlarge"></g:select>
    </f:field>
</f:with>
