package org.gualdi.grails.plugins.cms

import org.codehaus.groovy.grails.plugins.springsecurity.SpringSecurityUtils

abstract class AbstractUsersControllerMixin {

    // =====================================================================
    // Utility methods
    // =====================================================================
    
    protected void setIfMissing(String paramName, long valueIfMissing, Long max = null) {
        long value = (params[paramName] ?: valueIfMissing).toLong()
        if (max) {
            value = Math.min(value, max)
        }
        params[paramName] = value
    }

    protected String lookupUserClassName() {
        SpringSecurityUtils.securityConfig.userLookup.userDomainClassName
    }

    protected Class<?> lookupUserClass() {
        grailsApplication.getDomainClass(lookupUserClassName()).clazz
    }

    protected String lookupRoleClassName() {
        SpringSecurityUtils.securityConfig.authority.className
    }

    protected Class<?> lookupRoleClass() {
        grailsApplication.getDomainClass(lookupRoleClassName()).clazz
    }

    protected String lookupUserRoleClassName() {
        SpringSecurityUtils.securityConfig.userLookup.authorityJoinClassName
    }

    protected Class<?> lookupUserRoleClass() {
        grailsApplication.getDomainClass(lookupUserRoleClassName()).clazz
    }
}