<%@ page contentType="text/html;charset=UTF-8" %>

<html xmlns="http://www.w3.org/1999/html">
    <head>
        <meta content="ixcms2" name="layout">
    </head>

    <body>
        <div class="page-header">
            <h1><g:message code="cms.newsletters.title"/></h1>
        </div>

        <div class="row-fluid">
            <g:render template="/cms/newsletters/actions"/>

            <div class="span9">
                <g:if test="${queue}">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th style="width: 60%"><g:message code="cmsNewslettersCommand.title.label"/></th>
                            <th style="width: 20%"><g:message code="cmsNewslettersCommand.date.label"/></th>
                            <th style="width: 20%; text-align: right;"><g:message code="cmsNewslettersCommand.remainingCount.label"/></th>
                        </tr>
                        </thead>
                        <tbody>
                        <g:each in="${queue}" var="i">
                            <tr>
                                <td>${i.title}</td>
                                <td><g:formatDate date="${i.date}" format="dd/MM/yyyy"/></td>
                                <td style="text-align: right;">${i.count}</td>
                            </tr>
                        </g:each>
                        </tbody>
                    </table>

                    <cmsadmin:link action="restartMailQueue" class="btn"></i><g:message code="cms.action.restartQueue"/></cmsadmin:link>
                </g:if>
                <g:else>
                    <g:message code="cms.newsletters.message.emptyQueue"/>
                </g:else>
            </div>
        </div> <!-- // row -->
    </body>
</html>


