<%@ page contentType="text/html;charset=UTF-8" %>

<html>
    <head>
        <meta name="layout" content="ixcms2"/>
    </head>

    <body>
        <div class="page-header">
            <h1><g:message code="cms.newsletters.title"/></h1>
        </div>

        <div class="row-fluid">

            <g:render template="/cms/newsletters/actions"/>

            <div class="span9">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th style="width: 10%"><g:message code="cmsNewslettersCommand.date.label"/></th>
                        <th style="width: 25%"><g:message code="cmsNewslettersCommand.title.label"/></th>
                        <th><g:message code="cmsNewslettersCommand.recipientsList.label"/></th>
                        <th style="width: 10%"><g:message code="cmsNewslettersCommand.status.label"/></th>
                        <th style="width: 15%">&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <g:each in="${list}" var="i">
                        <tr>
                            <td><g:formatDate date="${i.date}" format="dd/MM/yyyy"/></td>
                            <td>${i.title}</td>
                            <td>
                                <g:each in="${i.recipients.name}" var="r">
                                    <span class="label label-info">${r}</span>
                                </g:each>
                            </td>
                            <td>
                                <span class="label label-success">${i.status}</span>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <g:if test="${i.status == org.gualdi.grails.plugins.cms.enums.NewsletterStatus.EDITING || i.status == org.gualdi.grails.plugins.cms.enums.NewsletterStatus.SENT}">
                                        <g:link action="editNewsletter" id="${i.id}" params="[sitetag: params.sitetag]" class="btn btn-primary"><g:message code="cms.button.edit"/></g:link>
                                        <button class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                                            <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <g:if test="${i.status == org.gualdi.grails.plugins.cms.enums.NewsletterStatus.EDITING}">
                                                <li>
                                                    <g:link action="sendTestNewsletter" id="${i.id}" params="[sitetag: params.sitetag]"><i class="icon-share"></i> <g:message code="cms.button.sendTest"/></g:link>
                                                </li>
                                                <li>
                                                    <g:link action="sendNewsletter" id="${i.id}" params="[sitetag: params.sitetag]"><i class="icon-share"></i> <g:message code="cms.button.send"/></g:link>
                                                </li>
                                                <li class="divider"></li>
                                            </g:if>
                                            <li>
                                                <a href="javascript:void(0)" class="delete-button" data-row-id="${i.id}"><i class="icon-trash"></i> <g:message code="cms.button.delete"/>
                                                </a>
                                            </li>
                                        </ul>
                                    </g:if>
                                </div>
                            </td>
                        </tr>
                    </g:each>
                    </tbody>
                </table>

                <cmsadmin:paginate total="${list.totalCount}" params="[sitetag: params.sitetag]"/>
            </div>

            <div class="span1">
                &nbsp;
            </div>
        </div>

        <g:render plugin="ixcms2" template="/cms/common/dialogs/deleteDialog" model="[controller: 'cmsAdmin', action: 'deleteNewsletter', params: [sitetag: params.sitetag], dialogTitle: message(code: 'cms.newsletters.dialog.delete.title'), dialogBody: message(code: 'cms.newsletters.dialog.delete.body'), dialogId: 'delete-dialog', buttonClass: 'delete-button']"/>
    </body>
</html>