package org.gualdi.grails.plugins.cms.domain

class NewsletterGroup {
    Site site
	
	String tag
    String name

    static constraints = {
		site(nullable: false)
		tag(nullable: false, blank: false, maxSize: 50, matches: /[0-9a-z_-]*/, validator: { value, obj ->
            if (value) {
                def s = obj.site
                def groups = NewsletterGroup.findAllBySite(s)
                if (groups.any { g -> (g.tag == value) && (obj.id ? (g.id != obj.id) : true) }) {
                    return ['group.error.tagMustBeUnique']
                }
            }
        })
        name(nullable: false, blank: false, maxSize: 100)
    }

    /*
    Set<NewsletterSubscription> getSubscriptions() {
        NewsletterSubscriptionGroup.withNewSession {
            NewsletterSubscriptionGroup.findAllByGroup(this).collect { it.subscription } as Set
        }
    }
    */

    def beforeDelete() {
    	// throw new DataIntegrityViolationException("Cannot delete")
        NewsletterSubscriptionGroup.withNewSession {
            NewsletterSubscriptionGroup.removeAll(this)
        }
        NewsletterRecipient.withNewSession {
            NewsletterRecipient.removeAll(this)
        }
    }
}