package org.gualdi.grails.plugins.cms.domain

import org.gualdi.grails.plugins.cms.enums.NewsletterStatus

class Newsletter {
    Site site

    Date date
    Date dateSent
    String sender
    String title
    String body
    NewsletterStatus status
    String testAddress
    NewsletterTemplate template

    static constraints = {
        date(nullable: false)
        dateSent(nullable: true)
        sender(nullable: false, blank: false, email: true, maxSize: 255)
        title(nullable: false, blank: false, maxSize: 255)
        body(nullable: false, blank: false)
        status(nullable: false)
        testAddress(nullable: false, blank: false, email: true, maxSize: 255)
        template(nullable: false)
    }

    static mapping = {
        columns {
            body type: 'text'
        }
    }

    Set<NewsletterGroup> getRecipients() {
        NewsletterRecipient.withNewSession {
            NewsletterRecipient.findAllByNewsletter(this).collect { it.group } as Set
        }
    }

    def beforeDelete() {
    	// throw new DataIntegrityViolationException("Cannot delete")
        NewsletterRecipient.withNewSession {
            NewsletterRecipient.removeAll(this)
        }
    }
}