package org.gualdi.grails.plugins.cms.co

import grails.validation.Validateable
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes
import org.gualdi.grails.plugins.cms.domain.NewsletterTemplate
import org.springframework.context.ApplicationContext

@Validateable
class CmsNewsletterTemplateCommand {
    // Inject service, needed because we are manually creating the command object
    ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
    def cmsBaseNewslettersService = ctx.getBean('cmsBaseNewslettersService')

    Long id

    String name
    String code

	String sitetag

    static constraints = {
        id nullable: true

        importFrom NewsletterTemplate

        sitetag nullable: true, blank: true
    }
}
