package org.gualdi.grails.plugins.cms.co

import grails.validation.Validateable
import org.codehaus.groovy.grails.web.context.ServletContextHolder
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes
import org.springframework.context.ApplicationContext
import org.gualdi.grails.plugins.cms.domain.*

@Validateable
class CmsNewsletterGroupsCommand {

    // Inject service, needed because we are manually creating the command object
    ApplicationContext ctx = ServletContextHolder.getServletContext().getAttribute(GrailsApplicationAttributes.APPLICATION_CONTEXT)
    def cmsBaseNewslettersService = ctx.getBean('cmsBaseNewslettersService')

    Long id

    String tag
    String name

	String sitetag

    static constraints = {
        id nullable: true

        tag blank: true, nullable: true, maxSize: 50, matches: /[a-z0-9_-]*/, validator: { value, obj ->
            if (value) {
                if (!obj.cmsBaseNewslettersService.isNewsletterGroupTagUnique(value, obj.sitetag, obj.id)) {
                    return ['unique']
                }
            }
        }

        importFrom NewsletterGroup, exclude: ['tag']

        sitetag nullable: true, blank: true
    }
}
