<%@ page contentType="text/html;charset=UTF-8" %>

<html>
    <head>
        <meta name="layout" content="ixcms2"/>
    </head>

    <body>
        <div class="page-header">
            <h1><g:message code="cms.subscriptions.title"/></h1>
        </div>

        <div class="row-fluid">

            <g:render template="/cms/subscriptions/actions"/>

            <div class="span9">
                <g:form action="listSubscriptions" class="form-inline" params="[sitetag: params.sitetag]">
                    <label><g:message code="cmsSubscriptionsCommand.searchSubscription.label"/></label>
                    <div class="input-append">
                        <g:textField name="q" value="${params?.q}" class="input-xxlarge" autocomplete="off"></g:textField>
                        <g:submitButton class="btn" name="search" value="${message(code: 'cms.button.search')}"/>
                    </div>
                </g:form>

                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th style="width: 25%"><g:message code="cmsSubscriptionsCommand.surname.label"/></th>
                        <th style="width: 25%"><g:message code="cmsSubscriptionsCommand.name.label"/></th>
                        <th style="width: 35%"><g:message code="cmsSubscriptionsCommand.email.label"/></th>
                        <th style="width: 15%">&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <g:each in="${list}" var="i">
                        <tr>
                            <td>${i.surname}</td>
                            <td>${i.name}</td>
                            <td>${i.email}</td>
                            <td>
                                <a href="javascript:void(0)" class="btn btn-danger btn-small delete-button" data-row-id="${i.id}"><i class="icon-white icon-trash"></i> <g:message code="cms.button.delete"/>
                                </a>
                                %{--
                                <div class="btn-group">
                                    <g:link action="editSubscription" id="${i.id}" params="[sitetag: params.sitetag]" class="btn btn-primary"><g:message code="cms.button.edit"/></g:link>
                                    <button class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a href="javascript:void(0)" class="delete-button" data-row-id="${i.id}"><i class="icon-trash"></i> <g:message code="cms.button.delete"/>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                --}%
                            </td>
                        </tr>
                    </g:each>
                    </tbody>
                </table>

                <cmsadmin:paginate total="${list.totalCount}" params="[q: params.q, sitetag: params.sitetag]"/>
            </div>

            <div class="span1">
                &nbsp;
            </div>
        </div>

        <g:render plugin="ixcms2" template="/cms/common/dialogs/deleteDialog" model="[controller: 'cmsAdmin', action: 'deleteSubscription', params: [sitetag: params.sitetag], dialogTitle: message(code: 'cms.subscriptions.dialog.delete.title'), dialogBody: message(code: 'cms.subscriptions.dialog.delete.body'), dialogId: 'delete-dialog', buttonClass:'delete-button']"/>
    </body>
</html>