<r:require modules="form-utils"/>

<r:script>
    $(function () {
        $("#recipientsList").select2();
        initDatePicker('#date', 'dd/mm/yyyy');
    });
</r:script>

<g:render plugin="ixcms2" template="/cms/common/richEditorConfig"/>

<g:hiddenField name="id" value="${cmd.id}"/>

<f:with bean="${cmd}">
    <f:field property="template">
        <g:select name="template.id" value="${cmd?.template?.id}" from="${allTemplates}" optionKey="id" optionValue="name" class="input-xlarge" noSelection="['':'']"></g:select>
    </f:field>

    <f:field property="date">
        <div class="input-append">
            <g:textField name="${property}" value="${formatDate(date: value, format: 'dd/MM/yyyy')}" size="16" class="span8"/><span class="add-on"><i class="icon-th"></i></span>
        </div>
    </f:field>

    <f:field property="sender" input-class="input-xxlarge"/>

    <f:field property="testAddress" input-class="input-xxlarge"/>

    <f:field property="recipientsList">
        <g:select id="recipientsList" name="recipientsList" value="${value}" from="${allGroups}" optionKey="id" optionValue="name" multiple="yes" class="input-xxlarge"></g:select>
    </f:field>

    <f:field property="title" input-class="input-xxlarge"/>

    <f:field property="body">
        <cmsadmin:richEditor name="${property}" toolbar="Ixcms2" width="98%" height="300">${value}</cmsadmin:richEditor>
    </f:field>
</f:with>
