package org.gualdi.grails.plugins.cms.domain

import org.apache.commons.lang.builder.HashCodeBuilder

class NewsletterSubscriptionGroup implements Serializable {
    Site site

    NewsletterSubscription subscription
    NewsletterGroup group

	boolean equals(other) {
		if (!(other instanceof NewsletterSubscriptionGroup)) {
			return false
		}

		other.site?.id == site?.id &&
			other.subscription?.id == subscription?.id && 
			other.group?.id == group?.id
	}

	int hashCode() {
		def builder = new HashCodeBuilder()
		if (site) builder.append(site.id)
		if (subscription) builder.append(subscription.id)
		if (group) builder.append(group.id)
		builder.toHashCode()
	}
	
	static NewsletterSubscriptionGroup get(Long siteId, Long subscriptionId, Long groupId) {
        // WORKAROUND FOR http://jira.grails.org/browse/GRAILS-9696
        NewsletterSubscriptionGroup.find 'from NewsletterSubscriptionGroup where site.id=:siteId and subscription.id=:subscriptionId and group.id=:groupId',
			[siteId: siteId, subscriptionId: subscriptionId, groupId: groupId]
	}

	static NewsletterSubscriptionGroup create(Site site, NewsletterSubscription subscription, NewsletterGroup group, boolean flush = false) {
		new NewsletterSubscriptionGroup(site: site, subscription: subscription, group: group).save(flush: flush, insert: true)
	}

	static boolean remove(NewsletterSubscription subscription, NewsletterGroup group, boolean flush = false) {
		NewsletterSubscriptionGroup instance = NewsletterSubscriptionGroup.findBySubscriptionAndGroup(subscription, group)
		instance ? instance.delete(flush: flush) : false
	}

	static void removeAll(NewsletterSubscription subscription) {
		executeUpdate 'DELETE FROM NewsletterSubscriptionGroup WHERE subscription=:subscription', [subscription: subscription]
	}

	static void removeAll(NewsletterGroup group) {
		executeUpdate 'DELETE FROM NewsletterSubscriptionGroup WHERE group=:group', [group: group]
	}

    static mapping = {
		id composite: ['site', 'subscription', 'group']
		version false
	}

    static constraints = {
    	site nullable: false
    	subscription nullable: false
    	group nullable: false
    }
}
