package org.gualdi.grails.plugins.cms.domain

class NewsletterSubscription {
    Site site

    String name
    String surname
    String email
    Boolean validated = false

    static constraints = {
		site(nullable: false)
        name(nullable: true, blank: true, maxSize: 100)
        surname(nullable: true, blank: true, maxSize: 100)
        email(nullable: false, blank: false, email: true, unique: 'site')
        validated(nullable: true)
    }

    def beforeDelete() {
    	// throw new DataIntegrityViolationException("Cannot delete")
        NewsletterSubscriptionGroup.withNewSession {
            NewsletterSubscriptionGroup.removeAll(this)
        }
    }
}
