package org.gualdi.grails.plugins.cms.domain

import org.apache.commons.lang.builder.HashCodeBuilder

class NewsletterRecipient implements Serializable {
	Newsletter newsletter
	NewsletterGroup group

	boolean equals(other) {
		if (!(other instanceof NewsletterRecipient)) {
			return false
		}

		other.newsletter?.id == newsletter?.id && 
			other.group?.id == group?.id
	}

	int hashCode() {
		def builder = new HashCodeBuilder()
		if (newsletter) builder.append(newsletter.id)
		if (group) builder.append(group.id)
		builder.toHashCode()
	}
	
	static NewsletterRecipient get(Long newsletterId, Long groupId) {
		find 'from NewsletterRecipient where newsletter.id=:newsletterId and group.id=:groupId',
			[newsletterId: newsletterId, groupId: groupId]
	}

	static NewsletterRecipient create(Newsletter newsletter, NewsletterGroup group, boolean flush = false) {
		new NewsletterRecipient(newsletter: newsletter, group: group).save(flush: flush, insert: true)
	}

	static boolean remove(Newsletter newsletter, NewsletterGroup group, boolean flush = false) {
		NewsletterRecipient instance = NewsletterRecipient.findByNewsletterAndGroup(newsletter, group)
		instance ? instance.delete(flush: flush) : false
	}

	static void removeAll(Newsletter newsletter) {
		executeUpdate 'DELETE FROM NewsletterRecipient WHERE newsletter=:newsletter', [newsletter: newsletter]
	}

	static void removeAll(NewsletterGroup group) {
		executeUpdate 'DELETE FROM NewsletterRecipient WHERE group=:group', [group: group]
	}

    static mapping = {
		id composite: ['newsletter', 'group']
		version false
	}

    static constraints = {
    	newsletter nullable: false
    	group nullable: false
    }
}
