package org.gualdi.grails.plugins.cms

import org.gualdi.grails.plugins.cms.co.CmsNewsletterGroupsCommand
import org.gualdi.grails.plugins.cms.co.CmsNewsletterTemplateCommand
import org.gualdi.grails.plugins.cms.co.CmsNewslettersCommand
import org.gualdi.grails.plugins.cms.exceptions.CannotDeleteNewsletterException
import org.gualdi.grails.plugins.cms.exceptions.CannotDeleteNewsletterGroupException
import org.gualdi.grails.plugins.cms.exceptions.CannotDeleteNewsletterSubscriptionException
import org.gualdi.grails.plugins.cms.exceptions.CannotDeleteNewsletterTemplateException

import javax.servlet.ServletContext

class NewslettersControllerMixin {

    def cmsBaseService
    def cmsBaseNewslettersService

    static menuEntry = [
            key: "cms.menu.newsletters",
            order: 70,
            useSitetag: true,
            items: [
                    [key: 'cms.menu.newsletters.manageNewsletters', action: 'listNewsletters'],
                    [key: 'cms.menu.newsletters.manageGroups', action: 'listNewsletterGroups'],
                    [key: 'cms.menu.newsletters.manageSubscriptions', action: 'listSubscriptions'],
                    [key: 'cms.menu.newsletters.manageTemplates', action: 'listNewsletterTemplates'],
                    [key: 'cms.menu.newsletters.mailQueue', action: 'listMailQueue']
            ]
    ]

    // =====================================================================
    // Newsletters
    // =====================================================================

    def listNewsletters() {
        def sitetag = params.sitetag
        def newsletters = cmsBaseNewslettersService.listNewsletters(sitetag, params)

        render view: "/cms/newsletters/list", model: [list: newsletters]
    }

    def addNewsletter() {
        def sitetag = params.sitetag

        CmsNewslettersCommand cmd = new CmsNewslettersCommand()

        def allGroups = cmsBaseNewslettersService.listAllNewslettersGroups(sitetag)
        def allTemplates = cmsBaseNewslettersService.listAllNewslettersTemplates(sitetag)

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseNewslettersService.saveNewsletter(cmd, sitetag)

                flash.message = "cms.newsletters.message.newsletterSaved"
                redirect action: "listNewsletters", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/newsletters/add", model: [cmd: cmd, allGroups: allGroups, allTemplates: allTemplates]
            }
        }
        else {
            render view: "/cms/newsletters/add", model: [cmd: cmd, allGroups: allGroups, allTemplates: allTemplates]
        }
    }

    def editNewsletter() {
        def sitetag = params.sitetag

        CmsNewslettersCommand cmd = new CmsNewslettersCommand()

        def allGroups = cmsBaseNewslettersService.listAllNewslettersGroups(sitetag)
        def allTemplates = cmsBaseNewslettersService.listAllNewslettersTemplates(sitetag)

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseNewslettersService.updateNewsletter(cmd, sitetag)

                flash.message = "cms.newsletters.message.newsletterUpdated"
                redirect action: "listNewsletters", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/newsletters/edit", model: [cmd: cmd, allGroups: allGroups, allTemplates: allTemplates]
            }
        }
        else {
            def newsletter = cmsBaseNewslettersService.getNewsletter(params.long("id"))
            bindData(cmd, newsletter.properties)
            cmd.id = newsletter.id
            cmd.recipientsList = newsletter.recipients.id
            render view: "/cms/newsletters/edit", model: [cmd: cmd, allGroups: allGroups, allTemplates: allTemplates]
        }
    }

    def deleteNewsletter() {
        def sitetag = params.sitetag
        def id = params.long("id")

        try {
            cmsBaseNewslettersService.deleteNewsletter(id, sitetag)
            flash.message = "cms.newsletters.message.newsletterDeleted"
        }
        catch (CannotDeleteNewsletterException cdne) {
            flash.error = "cms.newsletters.error.cannotDeleteNewsletter"
        }

        redirect action: "listNewsletters", params: [sitetag: sitetag]
    }

    def cancelNewsletter() {
        redirect action: "listNewsletters", params: [sitetag: params.sitetag]
    }

    def sendTestNewsletter() {
        def sitetag = params.sitetag

        flash.message = "cms.newsletters.message.newsletterTestSent"
        cmsBaseNewslettersService.sendForTest(params.long("id"))
        redirect action: "listNewsletters", params: [sitetag: sitetag]
    }

    def sendNewsletter() {
        def sitetag = params.sitetag

        if (request.post) {
            flash.message = "cms.newsletters.message.newsletterSent"
            cmsBaseNewslettersService.sendForReal(params.long("id"))
            redirect action: "listNewsletters", params: [sitetag: sitetag]
        }
        else {
            def newsletter = cmsBaseNewslettersService.getNewsletter(params.long("id"))
            def totalRecipients = cmsBaseNewslettersService.calculateRecipientsNumber(params.long("id"))
            render view: "/cms/newsletters/send", model: [cmd: newsletter, totalRecipients: totalRecipients]
        }
    }

    // =====================================================================
    // Newsletters groups
    // =====================================================================

    def listNewsletterGroups() {
        def sitetag = params.sitetag
        def groups = cmsBaseNewslettersService.listNewsletterGroups(sitetag, params)

        render view: "/cms/newsletterGroups/list", model: [list: groups]
    }

    def addNewsletterGroup() {
        def sitetag = params.sitetag

        CmsNewsletterGroupsCommand cmd = new CmsNewsletterGroupsCommand()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseNewslettersService.saveNewsletterGroup(cmd, sitetag)

                flash.message = "cms.newsletterGroups.message.newsletterGroupSaved"
                redirect action: "listNewsletterGroups", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/newsletterGroups/add", model: [cmd: cmd]
            }
        }
        else {
            render view: "/cms/newsletterGroups/add", model: [cmd: cmd]
        }
    }

    def editNewsletterGroup() {
        def sitetag = params.sitetag

        CmsNewsletterGroupsCommand cmd = new CmsNewsletterGroupsCommand()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseNewslettersService.updateNewsletterGroup(cmd, sitetag)

                flash.message = "cms.newsletterGroups.message.newsletterGroupUpdated"
                redirect action: "listNewsletterGroups", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/newsletterGroups/edit", model: [cmd: cmd]
            }
        }
        else {
            def group = cmsBaseNewslettersService.getNewsletterGroup(params.long("id"))
            bindData(cmd, group.properties)
            cmd.id = group.id
            render view: "/cms/newsletterGroups/edit", model: [cmd: cmd]
        }
    }

    def deleteNewsletterGroup() {
        def sitetag = params.sitetag
        def id = params.long("id")

        try {
            cmsBaseNewslettersService.deleteNewsletterGroup(id, sitetag)
            flash.message = "cms.newsletterGroups.message.newsletterGroupDeleted"
        }
        catch (CannotDeleteNewsletterGroupException cdne) {
            flash.error = "cms.newsletterGroups.error.cannotDeleteNewsletterGroup"
        }

        redirect action: "listNewsletterGroups", params: [sitetag: sitetag]
    }

    def cancelNewsletterGroup() {
        redirect action: "listNewsletterGroups", params: [sitetag: params.sitetag]
    }

    // =====================================================================
    // Templates
    // =====================================================================

    def listNewsletterTemplates() {
        def sitetag = params.sitetag
        def templates = cmsBaseNewslettersService.listNewsletterTemplates(sitetag, params)

        render view: "/cms/templates/list", model: [list: templates]
    }

    def addNewsletterTemplate() {
        def sitetag = params.sitetag

        CmsNewsletterTemplateCommand cmd = new CmsNewsletterTemplateCommand()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseNewslettersService.saveNewsletterTemplate(cmd, sitetag)

                flash.message = "cms.newsletterTemplates.message.newsletterTemplateSaved"
                redirect action: "listNewsletterTemplates", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/templates/add", model: [cmd: cmd]
            }
        }
        else {
            render view: "/cms/templates/add", model: [cmd: cmd]
        }
    }

    def editNewsletterTemplate() {
        def sitetag = params.sitetag

        CmsNewsletterTemplateCommand cmd = new CmsNewsletterTemplateCommand()

        if (request.post) {
            bindData(cmd, params)
            if (cmd.validate()) {
                cmsBaseNewslettersService.updateNewsletterTemplate(cmd, sitetag)

                flash.message = "cms.newsletterTemplates.message.newsletterTemplateUpdated"
                redirect action: "listNewsletterTemplates", params: [sitetag: sitetag]
            }
            else {
                render view: "/cms/templates/edit", model: [cmd: cmd]
            }
        }
        else {
            def template = cmsBaseNewslettersService.getNewsletterTemplate(params.long("id"))
            bindData(cmd, template.properties)
            cmd.id = template.id
            render view: "/cms/templates/edit", model: [cmd: cmd]
        }
    }

    def deleteNewsletterTemplate() {
        def sitetag = params.sitetag
        def id = params.long("id")

        try {
            cmsBaseNewslettersService.deleteNewsletterTemplate(id, sitetag)
            flash.message = "cms.newsletterTemplates.message.newsletterTemplateDeleted"
        }
        catch (CannotDeleteNewsletterTemplateException cdne) {
            flash.error = "cms.newsletterTemplates.error.cannotDeleteNewsletterTemplate"
        }

        redirect action: "listNewsletterTemplates", params: [sitetag: sitetag]
    }

    def cancelNewsletterTemplate() {
        redirect action: "listNewsletterTemplates", params: [sitetag: params.sitetag]
    }

    // =====================================================================
    // Subscriptions
    // =====================================================================

    def listSubscriptions() {
        def sitetag = params.sitetag
        def subscriptions = cmsBaseNewslettersService.listSubscriptions(sitetag, params)

        render view: "/cms/subscriptions/list", model: [list: subscriptions]
    }

    def deleteSubscription() {
        def sitetag = params.sitetag
        def id = params.long("id")

        try {
            cmsBaseNewslettersService.deleteSubscription(id, sitetag)
            flash.message = "cms.newsletterSubscriptions.message.newsletterSubscriptionDeleted"
        }
        catch (CannotDeleteNewsletterSubscriptionException cdne) {
            flash.error = "cms.newsletterSubscriptions.error.cannotDeleteNewsletterSubscription"
        }

        redirect action: "listSubscriptions", params: [sitetag: sitetag]
    }

    def cancelSubscription() {
        redirect action: "listSubscriptions", params: [sitetag: params.sitetag]
    }

    def exportSubscriptions() {
        def sitetag = params.sitetag
        def groups = params.groups

        def allGroups = cmsBaseNewslettersService.listAllNewslettersGroups(sitetag)

        if (request.post) {
            try {
                File file = cmsBaseNewslettersService.exportSubscriptions(sitetag, groups)
                if (file) {
                    def downloadFilename = "subscriptions.xls"
                    sendSubscriptionsFile(file, downloadFilename)
                    file.delete()
                    return null
                }
                else {
                    flash.message = "cms.subscriptions.message.export.noData"
                    redirect action: "exportSubscriptions", params: [sitetag: sitetag]
                }
            }
            catch (Exception dee) {
                dee.printStackTrace()
                flash.error = "cms.subscriptions.error.export.error"
                redirect action: "exportSubscriptions", params: [sitetag: sitetag]
            }
        }
        else {
            render view: "/cms/subscriptions/export", model: [allGroups: allGroups]
        }
    }

    def importSubscriptions() {
        def sitetag = params.sitetag
        def groups = params.groups

        def allGroups = cmsBaseNewslettersService.listAllNewslettersGroups(sitetag)

        if (request.post) {
            def f = request.getFile('inputFile')

            // ServletContext context = getServletContext()
            // def path = context.getRealPath("/temp")

            if (f && !f.empty) {
                // File targetFile = new File("${path}/tmpfile.tmp")
                File targetFile = File.createTempFile("temp", ".tmp")
                f.transferTo(targetFile)

                def results = cmsBaseNewslettersService.importSubscriptions(targetFile, sitetag, groups)

                targetFile.delete()

                flash.message = "cms.subscriptions.message.uploaded"
                flash.args = [results.created, results.updated, results.duplicated, results.errors, results.totalTime]

                redirect action: 'importSubscriptions', params: [sitetag: sitetag]
            }
            else {
                flash.error = 'cms.subscriptions.message.import.fileEmpty'
                render view: '/cms/subscriptions/import', model: [allGroups: allGroups]
            }
        }
        else {
            render view: "/cms/subscriptions/import", model: [allGroups: allGroups]
        }
    }

    def deleteSubscriptions() {
        def sitetag = params.sitetag

        if (request.post) {
            def f = request.getFile('inputFile')

            // ServletContext context = getServletContext()
            // def path = context.getRealPath("/temp")

            if (f && !f.empty) {
                // File targetFile = new File("${path}/tmpfile.tmp")
                File targetFile = File.createTempFile("temp", ".tmp")
                f.transferTo(targetFile)

                def results = cmsBaseNewslettersService.deleteSubscriptions(targetFile, sitetag)

                targetFile.delete()

                flash.message = "cms.subscriptions.message.deleted"
                flash.args = [results.deleted, results.duplicated, results.errors, results.totalTime]

                redirect action: 'deleteSubscriptions', params: [sitetag: sitetag]
            }
            else {
                flash.error = 'cms.subscriptions.message.import.fileEmpty'
                render view: '/cms/subscriptions/delete'
            }
        }
        else {
            render view: "/cms/subscriptions/delete"
        }
    }

    // =====================================================================
    // Mail queue
    // =====================================================================

    def listMailQueue() {
        def sitetag = params.sitetag

        def queueData = cmsBaseNewslettersService.getMailQueue(sitetag)
        render view: "/cms/newsletters/queue", model: [queue: queueData]
    }

    def restartMailQueue() {
        def sitetag = params.sitetag

        cmsBaseNewslettersService.restartQueue()

        flash.message = "cms.newsletters.message.mailQueueRestarted"
        redirect action: 'listMailQueue', params: [sitetag: sitetag]
    }

    // =====================================================================
    // Utils
    // =====================================================================

    private sendSubscriptionsFile(File file, String downloadFilename) {
        ServletContext context = getServletContext()

        response.setHeader("Content-Type", "application/force-download")
        response.setHeader("Content-Disposition", "attachment; filename=\"${downloadFilename}\"")
        response.setHeader("Content-Length", "${file.size()}")
        response.setHeader("Content-Transfer-Encoding", "Binary");

        def os = response.outputStream

        byte[] buff = null
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file))
        try {
            buff = new byte[2048]
            int bytesRead = 0
            while ((bytesRead = bis.read(buff, 0, buff.size())) != -1) {
                os.write(buff, 0, bytesRead)
            }
        }
        finally {
            bis.close()
            os.flush()
            os.close()
        }
    }
}
